/*
 * Decompiled with CFR 0.152.
 */
package dev.felixagairu.configmanager;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.felixagairu.configmanager.exceptions.FileHandleException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigManager {
    private final Gson GSON = new Gson();
    private final File CONFIG_FILE;
    private final JsonObject DEFAULT_CONFIGS;

    public ConfigManager(String configFileName, String configDefault) {
        this.DEFAULT_CONFIGS = JsonParser.parseString((String)configDefault).getAsJsonObject();
        Path configPath = FMLPaths.CONFIGDIR.get();
        this.CONFIG_FILE = configPath.resolve(configFileName).toFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject loadConfig() {
        try (FileReader reader = new FileReader(this.CONFIG_FILE);){
            JsonObject jO = (JsonObject)this.GSON.fromJson((Reader)reader, JsonObject.class);
            if (jO == null) throw new FileHandleException("Empty config file");
            JsonObject jsonObject = jO;
            return jsonObject;
        }
        catch (FileNotFoundException e) {
            if (!this.resetConfig()) throw new FileHandleException("Failed to reset config: " + e.getMessage());
            return this.loadConfig();
        }
        catch (IOException e) {
            throw new FileHandleException("Failed to load config: " + e.getMessage());
        }
    }

    public boolean saveConfig(JsonObject config) {
        boolean bl;
        FileWriter writer = new FileWriter(this.CONFIG_FILE);
        try {
            this.GSON.toJson((JsonElement)config, (Appendable)writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FileHandleException("Failed to save config: " + e.getMessage());
            }
        }
        ((Writer)writer).close();
        return bl;
    }

    public boolean resetConfig() {
        return this.saveConfig(this.DEFAULT_CONFIGS);
    }
}

