package me.basiqueevangelist.onedatastore.api;

import me.basiqueevangelist.onedatastore.impl.OneDataStoreInit;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

import java.util.function.Function;

@ApiStatus.NonExtendable
public interface Component<T extends ComponentInstance, C>  {
    class_2960 id();

    Function<C, T> factory();

    static <T extends ComponentInstance> Component<T, PlayerDataEntry> registerPlayer(class_2960 id, Function<PlayerDataEntry, T> factory) {
        return OneDataStoreInit.registerPlayerComponent(id, factory);
    }

    static <T extends ComponentInstance> Component<T, DataStore> registerGlobal(class_2960 id, Function<DataStore, T> factory) {
        return OneDataStoreInit.registerGlobalComponent(id, factory);
    }
}
