package me.basiqueevangelist.onedatastore.impl;

import me.basiqueevangelist.onedatastore.api.Component;
import me.basiqueevangelist.onedatastore.api.ComponentInstance;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.onedatastore.api.PlayerDataEntry;
import me.basiqueevangelist.pingspam.PingSpam;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import java.util.*;

public class OneDataStoreState extends class_18 implements DataStore {
    private final Map<UUID, PlayerDataEntryImpl> players = new HashMap<>();
    private final Map<Component<?, DataStore>, ComponentInstance> components = new HashMap<>();
    private static final ReentrantLoadProtector SAFEGUARD = new ReentrantLoadProtector(() -> new IllegalStateException("Tried to recursively load OneDataStore state!"));
    private static final class_10741<OneDataStoreState> TYPE = new class_10741<>(
        "onedatastore",
        OneDataStoreState::new,
        class_2487.field_25128.xmap(x -> new OneDataStoreState(x, PingSpam.SERVER.method_30611()), x -> x.writeNbt(new class_2487(), PingSpam.SERVER.method_30611())),
        null
    );

    public static OneDataStoreState getFrom(MinecraftServer server) {
        try (var scope = SAFEGUARD.enter()) {
            return server.method_30002().method_17983().method_17924(
                TYPE
            );
        }
    }

    private OneDataStoreState() {
        for (Component<?, DataStore> comp : OneDataStoreInit.GLOBAL_COMPONENTS.values()) {
            ComponentInstance inst = comp.factory().apply(this);
            inst.wasMissing();
            components.put(comp, inst);
        }
    }

    private OneDataStoreState(class_2487 tag, class_7225.class_7874 registries) {
        var playersTag = tag.method_68569("Players");
        for (int i = 0; i < playersTag.size(); i++) {
            var playerTag = playersTag.method_68582(i);

            UUID playerId = playerTag.method_67491("UUID", class_4844.field_40825).orElseThrow();

            players.put(playerId, new PlayerDataEntryImpl(this, playerId));
        }

        for (Component<?, DataStore> comp : OneDataStoreInit.GLOBAL_COMPONENTS.values()) {
            components.put(comp, comp.factory().apply(this));
        }

        for (int i = 0; i < playersTag.size(); i++) {
            var playerTag = playersTag.method_68582(i);

            UUID playerId = playerTag.method_67491("UUID", class_4844.field_40825).orElseThrow();

            players.get(playerId).fromTag(playerTag, registries);
        }

        for (Map.Entry<Component<?, DataStore>, ComponentInstance> entry : components.entrySet()) {
            var tagName = entry.getKey().id().toString();

            if (tag.method_10545(tagName)) {
                try {
                    entry.getValue().fromTag(tag.method_68568(tagName), registries);
                } catch (Exception e) {
                    OneDataStoreInit.LOGGER.error("Encountered error while deserializing {}", tagName, e);
                }
            } else {
                entry.getValue().wasMissing();
            }
        }
    }

    @Override
    public PlayerDataEntry getPlayerEntry(UUID playerId) {
        return players.computeIfAbsent(playerId, id -> {
            var entry = new PlayerDataEntryImpl(this, id);
            entry.wasMissing();
            return entry;
        });
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T extends ComponentInstance> T get(Component<T, DataStore> component) {
        return (T) components.get(component);
    }

    @Override
    public <T extends ComponentInstance> T getPlayer(UUID playerId, Component<T, PlayerDataEntry> component) {
        return getPlayerEntry(playerId).get(component);
    }

    @Override
    public Collection<PlayerDataEntry> players() {
        return Collections.unmodifiableCollection(players.values());
    }

    public Map<UUID, PlayerDataEntryImpl> playersMap() {
        return players;
    }

    public void reinitComponent(Component<?, DataStore> component) {
        components.remove(component);
        ComponentInstance inst = component.factory().apply(this);
        inst.wasMissing();
        components.put(component, inst);
    }

    public class_2487 writeNbt(class_2487 tag, class_7225.class_7874 registries) {
        var playersTag = new class_2499();
        tag.method_10566("Players", playersTag);

        for (var entry : players.entrySet()) {
            playersTag.add(entry.getValue().toTag(new class_2487(), registries));
        }

        for (Map.Entry<Component<?, DataStore>, ComponentInstance> entry : components.entrySet()) {
            var tagName = entry.getKey().id().toString();

            try {
                tag.method_10566(tagName, entry.getValue().toTag(new class_2487(), registries));
            } catch (Exception e) {
                OneDataStoreInit.LOGGER.error("Encountered error while serializing {}", tagName, e);
            }
        }

        return tag;
    }

    @Override
    public boolean method_79() {
        return true;
    }
}
