package me.basiqueevangelist.onedatastore.impl;

import me.basiqueevangelist.onedatastore.api.Component;
import me.basiqueevangelist.onedatastore.api.ComponentInstance;
import me.basiqueevangelist.onedatastore.api.PlayerDataEntry;
import net.minecraft.class_2487;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerDataEntryImpl implements PlayerDataEntry {
    private final UUID playerId;
    private final OneDataStoreState state;
    private final Map<Component<?, PlayerDataEntry>, ComponentInstance> components = new HashMap<>();

    public PlayerDataEntryImpl(OneDataStoreState state, UUID playerId) {
        this.playerId = playerId;
        this.state = state;

        for (Component<?, PlayerDataEntry> comp : OneDataStoreInit.PLAYER_COMPONENTS.values()) {
            components.put(comp, comp.factory().apply(this));
        }
    }

    public void fromTag(class_2487 tag, class_7225.class_7874 registries) {
        for (Map.Entry<Component<?, PlayerDataEntry>, ComponentInstance> entry : components.entrySet()) {
            var tagName = entry.getKey().id().toString();

            if (tag.method_10545(tagName)) {
                try {
                    entry.getValue().fromTag(tag.method_68568(tagName), registries);
                } catch (Exception e) {
                    OneDataStoreInit.LOGGER.error("Encountered error while deserializing {} for {}", tagName, playerId, e);
                }
            } else {
                entry.getValue().wasMissing();
            }
        }
    }

    public void wasMissing() {
        for (Map.Entry<Component<?, PlayerDataEntry>, ComponentInstance> entry : components.entrySet()) {
            entry.getValue().wasMissing();
        }
    }

    @Override
    public UUID playerId() {
        return playerId;
    }

    @Override
    public OneDataStoreState dataStore() {
        return state;
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T extends ComponentInstance> T get(Component<T, PlayerDataEntry> component) {
        return (T) components.get(component);
    }

    public class_2487 toTag(class_2487 tag, class_7225.class_7874 registries) {
        tag.method_67494("UUID", class_4844.field_40825, playerId);

        for (Map.Entry<Component<?, PlayerDataEntry>, ComponentInstance> entry : components.entrySet()) {
            var tagName = entry.getKey().id().toString();

            try {
                tag.method_10566(tagName, entry.getValue().toTag(new class_2487(), registries));
            } catch (Exception e) {
                OneDataStoreInit.LOGGER.error("Encountered error while serializing {} for {}", tagName, playerId, e);
            }
        }

        return tag;
    }

    @Override
    public String toString() {
        return "PlayerDataEntryImpl{" +
            "playerId=" + playerId +
            '}';
    }
}
