package me.basiqueevangelist.onedatastore.impl.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.basiqueevangelist.onedatastore.api.Component;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.onedatastore.impl.OneDataStoreInit;
import me.basiqueevangelist.onedatastore.impl.OneDataStoreState;
import me.basiqueevangelist.pingspam.logic.PingspamPermissions;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class PurgeCommand {
    private static final SimpleCommandExceptionType NO_PLAYER_FOUND = new SimpleCommandExceptionType(class_2561.method_43470("Specified player not found."));
    private static final SimpleCommandExceptionType UNKNOWN_COMPONENT = new SimpleCommandExceptionType(class_2561.method_43470("Unknown component"));
    private static final SimpleCommandExceptionType TOO_MANY_PLAYERS = new SimpleCommandExceptionType(class_2561.method_43470("Can't mention many players at once!"));


    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("onedatastore")
                .then(method_9247("purge")
                    .requires(PingspamPermissions::purge)
                    .then(method_9247("player")
                        .then(method_9244("target", class_2191.method_9329())
                            .executes(PurgeCommand::purgePlayer)))
                    .then(method_9244("global", class_2232.method_9441())
                        .suggests(PurgeCommand::suggestGlobalComponents)
                        .executes(PurgeCommand::purgeGlobalComponent))));
    }

    public static GameProfile getOnePlayer(CommandContext<class_2168> ctx, String argName) throws CommandSyntaxException {
        Collection<GameProfile> profiles = class_2191.method_9330(ctx, argName);

        if (profiles.size() > 1)
            throw TOO_MANY_PLAYERS.create();

        return profiles.iterator().next();
    }

    private static int purgeGlobalComponent(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        var src = ctx.getSource();
        var store = OneDataStoreState.getFrom(ctx.getSource().method_9211());
        var componentId = class_2232.method_9443(ctx, "global");

        Component<?, DataStore> component = OneDataStoreInit.GLOBAL_COMPONENTS.get(componentId);

        if (component == null)
            throw UNKNOWN_COMPONENT.create();

        store.reinitComponent(component);

        src.method_9226(() -> class_2561.method_43470("Purged and reinitialized ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470(componentId.toString())
                .method_27692(class_124.field_1054))
            .method_27693("."), false);

        return 1;
    }

    private static CompletableFuture<Suggestions> suggestGlobalComponents(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        List<String> ids = new ArrayList<>();

        for (class_2960 id : OneDataStoreInit.GLOBAL_COMPONENTS.keySet()) {
            ids.add(id.toString());
        }

        return class_2172.method_9265(ids, builder);
    }

    private static int purgePlayer(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        var src = ctx.getSource();
        var profile = getOnePlayer(ctx, "target");
        var store = OneDataStoreState.getFrom(ctx.getSource().method_9211());

        if (store.playersMap().remove(profile.getId()) == null)
            throw NO_PLAYER_FOUND.create();

        src.method_9226(() -> class_2561.method_43470("Purged ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470(profile.getName())
                .method_27692(class_124.field_1075))
            .method_27693("'s custom data."), false);

        return 1;
    }
}
