package me.basiqueevangelist.pingspam.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.PingspamPlayerData;
import me.basiqueevangelist.pingspam.logic.NameLogic;
import me.basiqueevangelist.pingspam.logic.PingspamPermissions;
import me.basiqueevangelist.pingspam.network.ServerNetworkLogic;
import me.basiqueevangelist.pingspam.utils.CommandUtil;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class AliasCommand {
    private static final SimpleCommandExceptionType ALIAS_EXISTS = new SimpleCommandExceptionType(class_2561.method_43470("You already have that alias!"));
    private static final DynamicCommandExceptionType ALIAS_EXISTS_OTHER = new DynamicCommandExceptionType(x ->
        class_2561.method_43470(((GameProfile) x).getName()).method_10852(class_2561.method_43470(" already has that alias!")));
    private static final SimpleCommandExceptionType NO_SUCH_ALIAS = new SimpleCommandExceptionType(class_2561.method_43470("You don't have that alias!"));
    private static final DynamicCommandExceptionType NO_SUCH_ALIAS_OTHER = new DynamicCommandExceptionType(x ->
        class_2561.method_43470(((GameProfile) x).getName()).method_27693(" doesn't have that alias!"));
    private static final SimpleCommandExceptionType ALIAS_COLLISION = new SimpleCommandExceptionType(class_2561.method_43470("That is already a valid name!"));
    private static final SimpleCommandExceptionType INVALID_ALIAS = new SimpleCommandExceptionType(class_2561.method_43470("Invalid alias!"));
    private static final SimpleCommandExceptionType TOO_MANY_ALIASES = new SimpleCommandExceptionType(class_2561.method_43470("Too many aliases! (maximum is 10)"));
    public static final int ALIAS_LIMIT = 10;
    private static final Pattern ALIAS_PATTERN = Pattern.compile("^[\\w0-9_]{2,16}$", Pattern.UNICODE_CHARACTER_CLASS);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("pingspam")
                .then(method_9247("alias")
                    .then(method_9247("list")
                        .executes(AliasCommand::listAliases))
                    .then(method_9247("add")
                        .requires(PingspamPermissions::addOwnAlias)
                        .then(method_9244("alias", StringArgumentType.string())
                            .executes(AliasCommand::addAliases)))
                    .then(method_9247("remove")
                        .requires(PingspamPermissions::removeOwnAlias)
                        .then(method_9244("alias", StringArgumentType.string())
                            .executes(AliasCommand::removeAlias)
                            .suggests(AliasCommand::suggestOwnAliases)))
                    .then(method_9247("player")
                        .then(method_9244("player", class_2191.method_9329())
                            .suggests(CommandUtil::suggestPlayersExceptSelf)
                            .then(method_9247("list")
                                .executes(AliasCommand::listPlayerAliases))
                            .then(method_9247("add")
                                .requires(PingspamPermissions::addPlayerAlias)
                                .then(method_9244("alias", StringArgumentType.string())
                                    .executes(AliasCommand::addPlayerAlias)))
                            .then(method_9247("remove")
                                .requires(PingspamPermissions::removePlayerAlias)
                                .then(method_9244("alias", StringArgumentType.string())
                                    .executes(AliasCommand::removePlayerAlias)
                                    .suggests(AliasCommand::suggestPlayerAliases))))))
        );
    }

    private static CompletableFuture<Suggestions> suggestPlayerAliases(CommandContext<class_2168> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        GameProfile player = CommandUtil.getOnePlayer(ctx, "player");
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.getId(), PingSpam.PLAYER_DATA);

        for (String alias : data.aliases()) {
            builder.suggest(SuggestionsUtils.wrapString(alias));
        }

        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestOwnAliases(CommandContext<class_2168> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = ctx.getSource().method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        for (String alias : data.aliases()) {
            builder.suggest(SuggestionsUtils.wrapString(alias));
        }

        return builder.buildFuture();
    }

    private static int removePlayerAlias(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        String alias = StringArgumentType.getString(ctx, "alias");
        GameProfile player = CommandUtil.getOnePlayer(ctx, "player");
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.getId(), PingSpam.PLAYER_DATA);

        if (!ALIAS_PATTERN.asPredicate().test(alias))
            throw INVALID_ALIAS.create();

        if (!data.aliases().contains(alias))
            throw NO_SUCH_ALIAS_OTHER.create(player);

        data.aliases().remove(alias);

        if (!NameLogic.isValidName(src.method_9211(), alias, false))
            ServerNetworkLogic.removePossibleName(src.method_9211().method_3760(), alias);

        src.method_9226(
            () -> class_2561.method_43470("Removed alias ")
                .method_27692(class_124.field_1060)
                .method_10852(class_2561.method_43470('"' + alias + '"')
                    .method_27692(class_124.field_1054))
                .method_10852(class_2561.method_43470(" from "))
                .method_10852(class_2561.method_43470(player.getName())
                    .method_27692(class_124.field_1075))
                .method_10852(class_2561.method_43470(".")), true);

        return 0;
    }

    private static int addPlayerAlias(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        String newAlias = StringArgumentType.getString(ctx, "alias");
        GameProfile player = CommandUtil.getOnePlayer(ctx, "player");
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.getId(), PingSpam.PLAYER_DATA);

        if (!ALIAS_PATTERN.asPredicate().test(newAlias))
            throw INVALID_ALIAS.create();

        if (data.aliases().contains(newAlias))
            throw ALIAS_EXISTS_OTHER.create(player);

        if (NameLogic.isValidName(src.method_9211(), newAlias, false))
            throw ALIAS_COLLISION.create();

        if (data.aliases().size() >= ALIAS_LIMIT && !PingspamPermissions.bypassAliasLimit(src))
            throw TOO_MANY_ALIASES.create();

        data.aliases().add(newAlias);
        ServerNetworkLogic.addPossibleName(src.method_9211().method_3760(), newAlias);

        src.method_9226(
            () -> class_2561.method_43470("Added alias ")
                .method_27692(class_124.field_1060)
                .method_10852(class_2561.method_43470('"' + newAlias + '"')
                    .method_27692(class_124.field_1054))
                .method_10852(class_2561.method_43470(" to "))
                .method_10852(class_2561.method_43470(player.getName())
                    .method_27692(class_124.field_1075))
                .method_10852(class_2561.method_43470(".")), true);

        return 0;
    }

    private static int listPlayerAliases(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        GameProfile player = CommandUtil.getOnePlayer(ctx, "player");
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.getId(), PingSpam.PLAYER_DATA);

        StringBuilder headerBuilder = new StringBuilder();
        StringBuilder contentBuilder = new StringBuilder();
        headerBuilder.append(" has ");
        headerBuilder.append(data.aliases().size());
        headerBuilder.append(" alias");

        if (data.aliases().size() != 1)
            headerBuilder.append("es");

        if (data.aliases().size() > 0) {
            headerBuilder.append(": ");
            boolean isFirst = true;
            for (String alias : data.aliases()) {
                if (!isFirst)
                    contentBuilder.append(", ");
                isFirst = false;
                contentBuilder.append(alias);
            }
        } else {
            headerBuilder.append('.');
        }

        src.method_9226(() -> class_2561.method_43470(player.getName())
            .method_27692(class_124.field_1075)
            .method_10852(
                class_2561.method_43470(headerBuilder.toString())
                    .method_27692(class_124.field_1060)
            )
            .method_10852(
                class_2561.method_43470(contentBuilder.toString())
                    .method_27692(class_124.field_1054)
            ), false);

        return 0;
    }

    private static int removeAlias(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        String alias = StringArgumentType.getString(ctx, "alias");
        class_3222 player = src.method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        if (!ALIAS_PATTERN.asPredicate().test(alias))
            throw INVALID_ALIAS.create();

        if (!data.aliases().contains(alias))
            throw NO_SUCH_ALIAS.create();

        data.aliases().remove(alias);

        if (!NameLogic.isValidName(src.method_9211(), alias, false))
            ServerNetworkLogic.removePossibleName(src.method_9211().method_3760(), alias);

        src.method_9226(() -> class_2561.method_43470("Removed alias ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470('"' + alias + '"')
                .method_27692(class_124.field_1054))
            .method_10852(class_2561.method_43470(".")), false);

        return 0;
    }

    private static int addAliases(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        String newAlias = StringArgumentType.getString(ctx, "alias");
        class_3222 player = src.method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        if (!ALIAS_PATTERN.asPredicate().test(newAlias))
            throw INVALID_ALIAS.create();

        if (data.aliases().contains(newAlias))
            throw ALIAS_EXISTS.create();

        if (NameLogic.isValidName(src.method_9211(), newAlias, false))
            throw ALIAS_COLLISION.create();

        if (data.aliases().size() >= ALIAS_LIMIT && !PingspamPermissions.bypassAliasLimit(src))
            throw TOO_MANY_ALIASES.create();

        data.aliases().add(newAlias);
        ServerNetworkLogic.addPossibleName(src.method_9211().method_3760(), newAlias);

        src.method_9226(() -> class_2561.method_43470("Added alias ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470('"' + newAlias + '"')
                .method_27692(class_124.field_1054))
            .method_10852(class_2561.method_43470(".")), false);

        return 0;
    }

    private static int listAliases(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        StringBuilder headerBuilder = new StringBuilder();
        StringBuilder contentBuilder = new StringBuilder();

        headerBuilder.append("You have ");
        headerBuilder.append(data.aliases().size());
        headerBuilder.append(" alias");

        if (data.aliases().size() != 1)
            headerBuilder.append("es");

        if (data.aliases().size() > 0) {
            headerBuilder.append(": ");
            boolean isFirst = true;
            for (String alias : data.aliases()) {
                if (!isFirst)
                    contentBuilder.append(", ");
                isFirst = false;
                contentBuilder.append(alias);
            }
        } else {
            headerBuilder.append('.');
        }

        src.method_9226(
            () -> class_2561.method_43470(headerBuilder.toString())
                .method_27692(class_124.field_1060)
                .method_10852(class_2561.method_43470(contentBuilder.toString())
                    .method_27692(class_124.field_1054)), false);

        return 0;
    }
}
