package me.basiqueevangelist.pingspam.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.logic.GroupChatLogic;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2196;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.concurrent.CompletableFuture;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public final class ChatCommand {
    private ChatCommand() {

    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("pingspam")
                .then(method_9247("chat")
                    .executes(ChatCommand::clearChat)
                    .then(method_9244("group", StringArgumentType.string())
                        .suggests(ChatCommand::suggestChatGroups)
                        .executes(ChatCommand::switchChat)
                        .then(method_9244("message", class_2196.method_9340())
                            .executes(ChatCommand::sendToChat))))
        );
    }

    private static CompletableFuture<Suggestions> suggestChatGroups(CommandContext<class_2168> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        for (var group : DataStore.getFor(src.method_9211()).get(PingSpam.GLOBAL_DATA).groups().values()) {
            if (!group.hasChat() || !group.members().contains(ctx.getSource().method_9207().method_5667()))
                continue;

            builder.suggest(SuggestionsUtils.wrapString(group.name()));
        }

        return builder.buildFuture();
    }

    private static int switchChat(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        String groupName = StringArgumentType.getString(ctx, "group");
        var group = DataStore.getFor(src.method_9211()).get(PingSpam.GLOBAL_DATA).groups().get(groupName);

        if (group == null)
            throw GroupCommand.NO_SUCH_GROUP.create();

        if (!group.hasChat() || !group.members().contains(ctx.getSource().method_9207().method_5667()))
            throw GroupCommand.NO_SUCH_GROUP.create();

        GroupChatLogic.changeChat(src.method_9207(), groupName);

        src.method_9226(() -> class_2561.method_43470("Switched to the ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470("@" + groupName)
                .method_27692(class_124.field_1054))
            .method_27693(" chat."), false);

        return 1;
    }

    private static int clearChat(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        GroupChatLogic.changeChat(src.method_9207(), null);

        src.method_9226(() -> class_2561.method_43470("Switched to the global chat.")
            .method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int sendToChat(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        String groupName = StringArgumentType.getString(ctx, "group");
        var group = DataStore.getFor(src.method_9211()).get(PingSpam.GLOBAL_DATA).groups().get(groupName);

        if (group == null)
            throw GroupCommand.NO_SUCH_GROUP.create();

        class_3222 player = ctx.getSource().method_9207();
        if (!group.hasChat() || !group.members().contains(player.method_5667()))
            throw GroupCommand.NO_SUCH_GROUP.create();

        class_2196.method_45562(ctx, "message", msg -> {
            GroupChatLogic.sendIn(player, groupName, msg);
        });

        return 1;
    }
}
