package me.basiqueevangelist.pingspam.commands;


import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.PingspamPlayerData;
import me.basiqueevangelist.pingspam.logic.NameLogic;
import me.basiqueevangelist.pingspam.logic.PingspamPermissions;
import me.basiqueevangelist.pingspam.network.ServerNetworkLogic;
import me.basiqueevangelist.pingspam.utils.CommandUtil;
import me.basiqueevangelist.pingspam.utils.NameUtil;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class GroupCommand {
    private static final DynamicCommandExceptionType IN_GROUP_OTHER = new DynamicCommandExceptionType(x ->
        class_2561.method_43470(((GameProfile) x).getName()).method_10852(class_2561.method_43470(" is already in that group")));
    private static final DynamicCommandExceptionType NOT_IN_GROUP_OTHER = new DynamicCommandExceptionType(x ->
        class_2561.method_43470(((GameProfile) x).getName()).method_10852(class_2561.method_43470(" isn't in that group")));
    private static final SimpleCommandExceptionType NAME_COLLISION = new SimpleCommandExceptionType(class_2561.method_43470("That name is already taken"));
    public static final SimpleCommandExceptionType NO_SUCH_GROUP = new SimpleCommandExceptionType(class_2561.method_43470("No such group"));
    private static final SimpleCommandExceptionType INVALID_GROUPNAME = new SimpleCommandExceptionType(class_2561.method_43470("Invalid group name"));
    private static final Pattern GROUPNAME_PATTERN = Pattern.compile("^[\\w0-9_]{2,16}$", Pattern.UNICODE_CHARACTER_CLASS);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("pingspam")
                .then(method_9247("group")
                    .then(method_9244("group", StringArgumentType.string())
                        .suggests(GroupCommand::suggestGroups)
                        .then(method_9247("list")
                            .executes(GroupCommand::listPlayersInGroup))
                        .then(method_9247("add")
                            .requires(PingspamPermissions::addGroupPlayer)
                            .then(method_9244("player", class_2191.method_9329())
                                .suggests(CommandUtil::suggestPlayers)
                                .executes(GroupCommand::addPlayerToGroup)))
                        .then(method_9247("remove")
                            .requires(PingspamPermissions::addGroupPlayer)
                            .then(method_9244("player", class_2191.method_9329())
                                .suggests(CommandUtil::suggestPlayers)
                                .executes(GroupCommand::removePlayerFromGroup)))
                        .then(method_9247("pingable")
                            .requires(source -> PingspamPermissions.configureGroup(source) && PingSpam.CONFIG.getConfig().groupChatsEnabled)
                            .then(method_9244("value", BoolArgumentType.bool())
                                .executes(GroupCommand::configurePingable)))
                        .then(method_9247("haschat")
                            .requires(source -> PingspamPermissions.configureGroup(source) && PingSpam.CONFIG.getConfig().groupChatsEnabled)
                            .then(method_9244("value", BoolArgumentType.bool())
                                .executes(GroupCommand::configureGroupChat)))
                    ))
        );
    }

    private static int configurePingable(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        String groupName = StringArgumentType.getString(ctx, "group");
        var group = DataStore.getFor(src.method_9211()).get(PingSpam.GLOBAL_DATA).groups().get(groupName);

        if (group == null)
            throw NO_SUCH_GROUP.create();

        boolean value = BoolArgumentType.getBool(ctx, "value");
        boolean old = group.isPingable();
        group.isPingable(value);

        if (old && !value) {
            if (!NameLogic.isValidName(src.method_9211(), groupName, false))
                ServerNetworkLogic.removePossibleName(src.method_9211().method_3760(), groupName);
        } else if (!old && value) {
            ServerNetworkLogic.addPossibleName(src.method_9211().method_3760(), groupName);
        }

        src.method_9226(() -> class_2561.method_43470((value ? "Enabled" : "Disabled") + " pinging of ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470("@" + groupName)
                    .method_27692(class_124.field_1054))
            .method_27693("."), true);

        return 1;
    }

    private static int configureGroupChat(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        String groupName = StringArgumentType.getString(ctx, "group");
        var group = DataStore.getFor(src.method_9211()).get(PingSpam.GLOBAL_DATA).groups().get(groupName);

        if (group == null)
            throw NO_SUCH_GROUP.create();

        boolean value = BoolArgumentType.getBool(ctx, "value");
        group.hasChat(value);

        src.method_9226(() -> class_2561.method_43470((value ? "Enabled" : "Disabled") + " group chat for ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470("@" + groupName)
                .method_27692(class_124.field_1054))
            .method_27693("."), true);

        return 1;
    }

    private static CompletableFuture<Suggestions> suggestGroups(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        class_2168 src = ctx.getSource();

        for (String groupName : DataStore.getFor(src.method_9211()).get(PingSpam.GLOBAL_DATA).groups().keySet()) {
            builder.suggest(SuggestionsUtils.wrapString(groupName));
        }

        return builder.buildFuture();
    }

    private static int listPlayersInGroup(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        String groupName = StringArgumentType.getString(ctx, "group");
        var group = DataStore.getFor(src.method_9211()).get(PingSpam.GLOBAL_DATA).groups().get(groupName);

        if (group == null)
            throw NO_SUCH_GROUP.create();

        StringBuilder headerBuilder = new StringBuilder();
        StringBuilder contentBuilder = new StringBuilder();
        headerBuilder.append(" has ");
        headerBuilder.append(group.members().size());
        headerBuilder.append(" player");

        if (group.members().size() != 1)
            headerBuilder.append("s");

        if (group.members().size() > 0) {
            headerBuilder.append(": ");
            boolean isFirst = true;
            for (UUID playerId : group.members()) {
                if (!isFirst)
                    contentBuilder.append(", ");
                isFirst = false;
                contentBuilder.append(NameUtil.getNameFromUUID(playerId));
            }
        } else {
            headerBuilder.append('.');
        }

        src.method_9226(() -> class_2561.method_43470("Group ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470("@" + groupName)
                .method_27692(class_124.field_1054))
            .method_27693(headerBuilder.toString())
            .method_10852(class_2561.method_43470(contentBuilder.toString())
                .method_27692(class_124.field_1075)), false);

        return 0;
    }

    private static int removePlayerFromGroup(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        DataStore store = DataStore.getFor(src.method_9211());
        String group = StringArgumentType.getString(ctx, "group");
        GameProfile player = CommandUtil.getOnePlayer(ctx, "player");
        PingspamPlayerData data = store.getPlayer(player.getId(), PingSpam.PLAYER_DATA);

        if (!GROUPNAME_PATTERN.asPredicate().test(group))
            throw INVALID_GROUPNAME.create();

        if (!data.groups().contains(group))
            throw NOT_IN_GROUP_OTHER.create(player);

        store.get(PingSpam.GLOBAL_DATA).removePlayerFromGroup(group, player.getId());

        if (!NameLogic.isValidName(src.method_9211(), group, false))
            ServerNetworkLogic.removePossibleName(src.method_9211().method_3760(), group);

        src.method_9226(
            () -> class_2561.method_43470("Removed player ")
                .method_27692(class_124.field_1060)
                .method_10852(class_2561.method_43470(player.getName())
                    .method_27692(class_124.field_1075))
                .method_27693(" from group ")
                .method_10852(class_2561.method_43470(group)
                    .method_27692(class_124.field_1054))
                .method_10852(class_2561.method_43470(".")), true);

        return 0;
    }

    private static int addPlayerToGroup(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        var src = ctx.getSource();
        DataStore store = DataStore.getFor(src.method_9211());
        String group = StringArgumentType.getString(ctx, "group");
        GameProfile player = CommandUtil.getOnePlayer(ctx, "player");
        PingspamPlayerData data = store.getPlayer(player.getId(), PingSpam.PLAYER_DATA);

        if (!GROUPNAME_PATTERN.asPredicate().test(group))
            throw INVALID_GROUPNAME.create();

        if (data.groups().contains(group))
            throw IN_GROUP_OTHER.create(player);

        if (NameLogic.isValidName(src.method_9211(), group, true))
            throw NAME_COLLISION.create();

        store.get(PingSpam.GLOBAL_DATA).addPlayerToGroup(group, player.getId());
        ServerNetworkLogic.addPossibleName(src.method_9211().method_3760(), group);

        src.method_9226(
            () -> class_2561.method_43470("Added player ")
                .method_27692(class_124.field_1060)
                .method_10852(class_2561.method_43470(player.getName())
                    .method_27692(class_124.field_1075))
                .method_27693(" to group ")
                .method_10852(class_2561.method_43470("@" + group)
                    .method_27692(class_124.field_1054)
                .method_27693(".")), true);

        return 0;
    }
}
