package me.basiqueevangelist.pingspam.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.PingspamPlayerData;
import me.basiqueevangelist.pingspam.utils.CommandUtil;
import me.basiqueevangelist.pingspam.utils.NameUtil;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class PingIgnoreCommand {
    private static final SimpleCommandExceptionType PLAYER_NOT_IGNORED = new SimpleCommandExceptionType(class_2561.method_43470("You are not ignoring this player!"));
    private static final SimpleCommandExceptionType PLAYER_ALREADY_IGNORED = new SimpleCommandExceptionType(class_2561.method_43470("You have already ignored this player!"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("pingspam")
                .then(method_9247("ignore")
                    .then(method_9247("add")
                        .then(method_9244("player", class_2191.method_9329())
                            .suggests(CommandUtil::suggestPlayersExceptSelf)
                            .executes(PingIgnoreCommand::addIgnoredPlayer)))
                    .then(method_9247("remove")
                        .then(method_9244("player", class_2191.method_9329())
                            .suggests(PingIgnoreCommand::suggestIgnoredPlayers)
                            .executes(PingIgnoreCommand::removeIgnoredPlayer)))
                    .then(method_9247("list")
                        .executes(PingIgnoreCommand::listIgnoredPlayers)))
        );
    }

    private static CompletableFuture<Suggestions> suggestIgnoredPlayers(CommandContext<class_2168> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = ctx.getSource().method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        for (UUID ignoredId : data.ignoredPlayers()) {
            builder.suggest(SuggestionsUtils.wrapString(NameUtil.getNameFromUUID(ignoredId)));
        }

        return builder.buildFuture();
    }

    private static int addIgnoredPlayer(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        GameProfile offender = CommandUtil.getOnePlayer(ctx, "player");
        class_3222 player = src.method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        if (data.ignoredPlayers().contains(offender.getId())) {
            throw PLAYER_ALREADY_IGNORED.create();
        }

        data.ignoredPlayers().add(offender.getId());

        src.method_9226(() -> class_2561.method_43470("You are now ignoring ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470(offender.getName())
                .method_27692(class_124.field_1075))
            .method_10852(class_2561.method_43470(".")), false);

        return 0;
    }

    private static int removeIgnoredPlayer(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        GameProfile pardonee = CommandUtil.getOnePlayer(ctx, "player");
        class_3222 player = src.method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        if (!data.ignoredPlayers().contains(pardonee.getId()))
            throw PLAYER_NOT_IGNORED.create();

        data.ignoredPlayers().remove(pardonee.getId());

        src.method_9226(() -> class_2561.method_43470("You are no longer ignoring ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470(pardonee.getName())
                .method_27692(class_124.field_1075))
            .method_27693("."), false);

        return 0;
    }

    private static int listIgnoredPlayers(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        if (data.ignoredPlayers().isEmpty()) {
            src.method_9226(() -> class_2561.method_43470("You are not ignoring any players.")
                .method_27692(class_124.field_1060), false);
            return 0;
        }

        StringBuilder contentBuilder = new StringBuilder();
        for (UUID ignoredPlayerUuid : data.ignoredPlayers()) {
            contentBuilder.append("\n - ").append(NameUtil.getNameFromUUID(ignoredPlayerUuid));
        }

        src.method_9226(() -> class_2561.method_43470("You are ignoring " + data.ignoredPlayers().size() + " player(s):")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470(contentBuilder.toString())
                .method_27692(class_124.field_1075)), false);

        return 0;
    }
}
