package me.basiqueevangelist.pingspam.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.PingspamPlayerData;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class PingSoundCommand {
    private static final SimpleCommandExceptionType INVALID_SOUND = new SimpleCommandExceptionType(class_2561.method_43470("Invalid sound type!"));

    @SuppressWarnings("unchecked") // it'll be fine, i swear
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("pingspam")
                .then(method_9247("sound")
                    .then(method_9244("sound", class_2232.method_9441())
                        .suggests((SuggestionProvider<class_2168>)(Object) class_2321.field_10934)
                        .executes(PingSoundCommand::setPingSound))
                    .then(method_9247("none")
                        .executes(PingSoundCommand::removePingSound))
                    .executes(PingSoundCommand::getPingSound))
        );
    }

    private static int setPingSound(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);
        class_2960 soundId = class_2232.method_9443(ctx, "sound");
        class_3414 event = class_7923.field_41172.method_17966(soundId).orElseThrow(INVALID_SOUND::create);

        data.setPingSound(event);

        src.method_9226(() -> class_2561.method_43470("Set ping sound to ")
            .method_27692(class_124.field_1060)
            .method_10852(class_2561.method_43470(soundId.toString())
                .method_27692(class_124.field_1054))
            .method_10852(class_2561.method_43470(".")), false);

        return 0;
    }

    private static int removePingSound(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        data.setPingSound(null);

        src.method_9226(() -> class_2561.method_43470("Disabled ping sound.")
            .method_27692(class_124.field_1060), false);

        return 0;
    }

    private static int getPingSound(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_9207();
        PingspamPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        if (data.pingSound() != null) {
            src.method_9226(() -> class_2561.method_43470("Your current ping sound is ")
                .method_27692(class_124.field_1060)
                .method_10852(class_2561.method_43470(data.pingSound().comp_3319().toString())
                    .method_27692(class_124.field_1054))
                .method_10852(class_2561.method_43470(".")), false);
        } else {
            src.method_9226(() -> class_2561.method_43470("You have disabled ping sounds.")
                .method_27692(class_124.field_1060), false);
        }

        return 0;
    }
}
