package me.basiqueevangelist.pingspam.commands.mail;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.PechkinPlayerData;
import me.basiqueevangelist.pingspam.logic.PingspamPermissions;
import me.basiqueevangelist.pingspam.utils.CommandUtil;
import me.basiqueevangelist.pingspam.utils.NameUtil;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public final class ClearCommand {
    private ClearCommand() {

    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247("mail")
            .then(method_9247("clear")
                .executes(ClearCommand::clear)
                .then(method_9244("player", class_2191.method_9329())
                    .requires(PingspamPermissions::clearOtherMail)
                    .suggests(CommandUtil::suggestPlayersExceptSelf)
                    .executes(ClearCommand::clearOther))));
    }

    private static int clear(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_44023();
        PechkinPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PECHKIN_PLAYER_DATA);

        class_2561 sent = class_2561.method_43470("Deleted " + data.messages().size() + " message" + (data.messages().size() == 1 ? "" : "s") + " from your inbox.")
            .method_27692(class_124.field_1060);

        data.messages().clear();

        src.method_9226(() -> sent, false);

        return 1;
    }

    private static int clearOther(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        GameProfile player = CommandUtil.getOnePlayer(ctx, "player");
        PechkinPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.getId(), PingSpam.PECHKIN_PLAYER_DATA);

        class_2561 sent = class_2561.method_43470("Deleted " + data.messages().size() + " message" + (data.messages().size() == 1 ? "" : "s") + " from ")
            .method_10852(class_2561.method_43470(NameUtil.getNameFromUUID(player.getId())).method_27692(class_124.field_1075))
            .method_27693("'s inbox.")
            .method_27692(class_124.field_1060);

        data.messages().clear();

        src.method_9226(() -> sent, true);

        return 1;
    }
}
