package me.basiqueevangelist.pingspam.commands.mail;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.PechkinPlayerData;
import me.basiqueevangelist.pingspam.hack.StateTracker;
import me.basiqueevangelist.pingspam.logic.PingspamPermissions;
import me.basiqueevangelist.pingspam.utils.CommandUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import java.util.UUID;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public final class DeleteCommand {
    private static final SimpleCommandExceptionType MESSAGE_DOESNT_EXIST = new SimpleCommandExceptionType(class_2561.method_43470("No such message"));

    private DeleteCommand() {

    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247("mail")
            .then(method_9247("internal")
                .requires(x -> !StateTracker.IS_IN_COMMAND_TREE_CREATION)
                .then(method_9247("delete_list")
                    .then(method_9244("message", class_5242.method_27643())
                        .executes(DeleteCommand::deleteList)))
                .then(method_9247("delete_list_other")
                    .requires(PingspamPermissions::listOtherMail)
                    .requires(PingspamPermissions::deleteOtherMail)
                    .then(method_9244("player", class_2191.method_9329())
                        .then(method_9244("message", class_5242.method_27643())
                            .executes(DeleteCommand::deleteListOther))))
                .then(method_9247("delete_silent")
                    .then(method_9244("message", class_5242.method_27643())
                        .executes(DeleteCommand::deleteSilent)))));
    }

    private static int deleteSilent(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_44023();
        UUID messageId = class_5242.method_27645(ctx, "message");
        PechkinPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PECHKIN_PLAYER_DATA);

        data.messages().removeIf(x -> x.messageId().equals(messageId));

        return 1;
    }

    private static int deleteList(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_44023();
        UUID messageId = class_5242.method_27645(ctx, "message");
        PechkinPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PECHKIN_PLAYER_DATA);

        if (!data.messages().removeIf(x -> x.messageId().equals(messageId))) {
            throw MESSAGE_DOESNT_EXIST.create();
        }

        src.method_9226(() -> class_2561.method_43470("\n\n"), false);

        // Resend the list, since this command will only be invoked via list anyway 🚎
        ListCommand.list(ctx);

        return 1;
    }

    private static int deleteListOther(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        UUID messageId = class_5242.method_27645(ctx, "message");
        GameProfile player = CommandUtil.getOnePlayer(ctx, "player");
        PechkinPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.getId(), PingSpam.PECHKIN_PLAYER_DATA);

        if (!data.messages().removeIf(x -> x.messageId().equals(messageId))) {
            throw MESSAGE_DOESNT_EXIST.create();
        }

        src.method_9226(() -> class_2561.method_43470("\n\n"), false);

        // Resend the list, since this command will only be invoked via list anyway 🚎
        ListCommand.listOther(ctx);

        return 1;
    }
}
