package me.basiqueevangelist.pingspam.commands.mail;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.MailMessage;
import me.basiqueevangelist.pingspam.data.PechkinPlayerData;
import me.basiqueevangelist.pingspam.logic.PingspamPermissions;
import me.basiqueevangelist.pingspam.utils.CommandUtil;
import me.basiqueevangelist.pingspam.utils.NameUtil;
import me.basiqueevangelist.pingspam.utils.TimeUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public final class ListCommand {
    private ListCommand() {

    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247("mail")
            .then(method_9247("list")
                .executes(ListCommand::list)
                .then(method_9244("player", class_2191.method_9329())
                    .suggests(CommandUtil::suggestPlayersExceptSelf)
                    .requires(PingspamPermissions::listOtherMail)
                    .executes(ListCommand::listOther)))
            .executes(ListCommand::list));
    }

    public static int listOther(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        GameProfile player = CommandUtil.getOnePlayer(ctx, "player");
        PechkinPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.getId(), PingSpam.PECHKIN_PLAYER_DATA);
        class_2561 playerName = class_2561.method_43470(player.getName())
            .method_27692(class_124.field_1075);

        class_5250 complete = class_2561.method_43470("")
            .method_10852(playerName)
            .method_27693(" has " + data.messages().size() + " message" + (data.messages().size() != 1 ? "s" : "") + " stored:");

        for (var message : data.messages()) {
            complete.method_10852(writeMessageDesc(message, playerName, "/mail internal delete_list_other " + player.getName() + " "));
        }

        src.method_9226(() -> complete, false);

        return 1;
    }

    public static int list(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_44023();
        PechkinPlayerData data = DataStore.getFor(src.method_9211()).getPlayer(player.method_5667(), PingSpam.PECHKIN_PLAYER_DATA);

        class_5250 complete = class_2561.method_43470("You have " + data.messages().size() + " message" + (data.messages().size() != 1 ? "s" : "") + " stored:");

        for (var message : data.messages()) {
            complete.method_10852(writeMessageDesc(message, player.method_5476(), "/mail internal delete_list "));
        }

        src.method_9226(() -> complete, false);

        return 1;
    }

    private static class_2561 writeMessageDesc(MailMessage msg, class_2561 playerName, String deleteCmdPrefix) {
        return class_2561.method_43470("\n[")
            .method_10852(class_2561.method_43470("✘")
                .method_27692(class_124.field_1061)
                .method_27694(x -> x
                    .method_10958(new class_2558.class_10609(deleteCmdPrefix + msg.messageId()))
                    .method_10949(new class_2568.class_10613(class_2561.method_43470("Delete message")))))
            .method_27693(" ")
            .method_10852(class_2561.method_43470("i")
                .method_27692(class_124.field_1078)
                .method_27694(x -> x.method_10949(new class_2568.class_10613((
                    class_2561.method_43470("Sent ")
                        .method_10852(TimeUtils.formatTime(msg.sentAt()))
                        .method_27693(" ago\nUUID: " + msg.messageId())
                )))))
            .method_27693("] ")
            .method_10852(class_2561.method_43470(NameUtil.getNameFromUUID(msg.sender())).method_27692(class_124.field_1075))
            .method_10852(class_2561.method_43470(" -> ").method_27692(class_124.field_1068))
            .method_10852(playerName.method_27661().method_27692(class_124.field_1075))
            .method_10852(class_2561.method_43470(": ").method_27692(class_124.field_1068))
            .method_10852(msg.contents());
    }
}
