package me.basiqueevangelist.pingspam.commands.mail;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.MailMessage;
import me.basiqueevangelist.pingspam.data.PechkinPlayerData;
import me.basiqueevangelist.pingspam.logic.IgnoreLogic;
import me.basiqueevangelist.pingspam.logic.MailLogic;
import me.basiqueevangelist.pingspam.logic.PingspamPermissions;
import me.basiqueevangelist.pingspam.utils.CommandUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2196;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.time.Instant;
import java.util.UUID;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public final class SendCommand {
    private static final SimpleCommandExceptionType IGNORED = new SimpleCommandExceptionType(class_2561.method_43470("That player has ignored you."));
    private static final SimpleCommandExceptionType RATELIMIT = new SimpleCommandExceptionType(class_2561.method_43470("You are being rate limited."));
    private static final SimpleCommandExceptionType NO_CORRESPONDENT = new SimpleCommandExceptionType(class_2561.method_43470("No correspondents recorded yet"));

    private SendCommand() {

    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247("mail")
            .then(method_9247("send")
                .then(method_9244("player", class_2191.method_9329())
                    .suggests(CommandUtil::suggestPlayers)
                    .then(method_9244("message", class_2196.method_9340())
                        .requires(PingspamPermissions::sendMail)
                        .executes(SendCommand::send)))));

        dispatcher.register(method_9247("r")
            .then(method_9244("message", class_2196.method_9340())
                .requires(PingspamPermissions::sendMail)
                .executes(SendCommand::reply)));
    }

    private static int send(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 sender = src.method_9207();
        GameProfile recipient = CommandUtil.getOnePlayer(ctx, "player");
        class_2561 message = class_2196.method_9339(ctx, "message");

        sendMessage(src, sender, recipient.getId(), message);

        return 1;
    }

    private static int reply(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 sender = src.method_9207();
        PechkinPlayerData senderData = DataStore.getFor(src.method_9211()).getPlayer(sender.method_5667(), PingSpam.PECHKIN_PLAYER_DATA);
        class_2561 message = class_2196.method_9339(ctx, "message");

        if (senderData.lastCorrespondents().size() <= 0)
            throw NO_CORRESPONDENT.create();

        UUID recipientId = senderData.lastCorrespondents().get(0);

        sendMessage(src, sender, recipientId, message);

        return 1;
    }

    private static void sendMessage(class_2168 src, class_3222 sender, UUID recipientId, class_2561 message) throws CommandSyntaxException {
        PechkinPlayerData senderData = DataStore.getFor(src.method_9211()).getPlayer(sender.method_5667(), PingSpam.PECHKIN_PLAYER_DATA);
        PechkinPlayerData recipientData = DataStore.getFor(src.method_9211()).getPlayer(recipientId, PingSpam.PECHKIN_PLAYER_DATA);

        IgnoreLogic.throwIfIgnored(sender, recipientId);

        if (!PingspamPermissions.bypassCooldown(sender)) {
            int sendCost = PingSpam.CONFIG.getConfig().mail.sendCost;

            if (!senderData.leakyBucket().hasEnoughFor(sendCost))
                throw RATELIMIT.create();

            senderData.leakyBucket().addTime(sendCost);
        }

        if (!recipientId.equals(sender.method_5667()))
            recipientData.addCorrespondent(sender.method_5667());

        MailMessage mail = new MailMessage(message, sender.method_5667(), UUID.randomUUID(), Instant.now());
        recipientData.addMessage(mail);
        MailLogic.notifyMailSent(recipientId, sender, mail);

        if (sender.method_5667().equals(recipientId)) return;

        MailLogic.notifyMailReceived(src.method_9211(), recipientId, sender, mail);
    }
}
