package me.basiqueevangelist.pingspam.data;

import me.basiqueevangelist.pingspam.PingSpam;
import net.minecraft.class_2487;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public final class LeakyBucket {
    private Instant debtExpiryTime;

    public LeakyBucket() {
        this(Instant.now());
    }

    public LeakyBucket(Instant debtExpiryTime) {
        this.debtExpiryTime = debtExpiryTime;
    }

    public void addTime(int cost) {
        Instant now = Instant.now();
        if (debtExpiryTime.isBefore(now))
            debtExpiryTime = now.plus(cost, ChronoUnit.SECONDS);
        else
            debtExpiryTime = debtExpiryTime.plus(cost, ChronoUnit.SECONDS);
    }

    public boolean hasEnoughFor(int cost) {
        return PingSpam.CONFIG.getConfig().mail.maxTimeDebt - Duration.between(Instant.now(), debtExpiryTime).get(ChronoUnit.SECONDS) > cost;
    }

    public boolean isFull() {
        return debtExpiryTime.isBefore(Instant.now());
    }

    public void fromTag(class_2487 tag) {
        if (tag.method_10545("LeakyBucketFillTime")) {
            debtExpiryTime = Instant.ofEpochMilli(tag.method_10537("LeakyBucketFillTime").orElse(Instant.now().toEpochMilli()));
        }
    }

    public void toTag(class_2487 tag) {
        if (debtExpiryTime.isAfter(Instant.now())) {
            tag.method_10544("LeakyBucketFillTime", debtExpiryTime.toEpochMilli());
        }
    }
}
