package me.basiqueevangelist.pingspam.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.basiqueevangelist.pingspam.utils.CodecUtil;
import net.minecraft.class_2561;
import net.minecraft.class_4844;
import java.time.Instant;
import java.util.UUID;

public record MailMessage(class_2561 contents, UUID sender, UUID messageId, Instant sentAt) {
    public static final Codec<MailMessage> CODEC = RecordCodecBuilder.create(i -> i.group(
        CodecUtil.TEXT_JSON.fieldOf("Contents").forGetter(MailMessage::contents),
        class_4844.field_40825.fieldOf("Sender").forGetter(MailMessage::sender),
        class_4844.field_40825.fieldOf("UUID").forGetter(MailMessage::messageId),
        Codec.LONG.xmap(Instant::ofEpochMilli, Instant::toEpochMilli).fieldOf("SentAt").forGetter(MailMessage::sentAt)
    ).apply(i, MailMessage::new));
}
