package me.basiqueevangelist.pingspam.data;

import com.mojang.serialization.Codec;
import me.basiqueevangelist.onedatastore.api.ComponentInstance;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.utils.CaseInsensitiveUtil;
import me.basiqueevangelist.pingspam.utils.CodecUtil;
import me.basiqueevangelist.pingspam.utils.OfflineUtil;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PingspamGlobalData implements ComponentInstance {
    private final static Logger LOGGER = LoggerFactory.getLogger("Pingspam/PingspamGlobalData");
    private final Map<String, PingspamGroupData> groups = CaseInsensitiveUtil.mapIgnoringCase();
    private final DataStore store;

    public PingspamGlobalData(DataStore store) {
        this.store = store;
    }

    @Override
    public void wasMissing() {
        LOGGER.info("Starting import of old Pingspam data");

        for (UUID playerId : OfflineUtil.listSavedPlayers()) {
            LOGGER.info("Importing {}", playerId);
            try {
                class_2487 tag = OfflineUtil.get(playerId);
                PingspamPlayerData data = store.getPlayer(playerId, PingSpam.PLAYER_DATA);

                if (tag.method_10545("UnreadPings")) {
                    List<class_2561> pings = tag.method_67491("UnreadPings", CodecUtil.TEXT_JSON.listOf()).orElse(List.of());
                    data.unreadPings().addAll(pings);
                }

                if (tag.method_10545("Shortnames")) {
                    List<String> aliases = tag.method_67491("Shortnames", Codec.STRING.listOf()).orElse(List.of());
                    data.aliases().addAll(aliases);
                }

                if (tag.method_10545("PingGroups")) {
                    List<String> pingGroups = tag.method_67491("PingGroups", Codec.STRING.listOf()).orElse(List.of());
                    for (String pingGroup : pingGroups) {
                        addPlayerToGroup(pingGroup, playerId);
                    }
                }

                if (tag.method_10545("IgnoredPlayers")) {
                    List<UUID> ignoredPlayerList = tag.method_67491("IgnoredPlayers", class_4844.field_40825.listOf()).orElse(List.of());
                    data.ignoredPlayers().addAll(ignoredPlayerList);
                }

                if (tag.method_10545("PingSound")) {
                    if (tag.method_10558("PingSound").orElse("").equals("null")) {
                        data.setPingSound(null);
                    } else {
                        data.setPingSound(class_7923.field_41172.method_17966(class_2960.method_60654(tag.method_10558("PingSound").orElseThrow())).orElse(class_3417.field_17265));
                    }
                }
            } catch (Exception e) {
                LOGGER.error("Error while reading data for {}", playerId, e);
            }
        }

        LOGGER.info("Finished import of old Pingspam data");
    }

    @Override
    public void fromTag(class_2487 tag, class_7225.class_7874 registries) {
        var groupsTag = tag.method_68568("Groups");
        for (String groupName : groupsTag.method_10541()) {
            var group = new PingspamGroupData(groupName);
            groups.put(groupName, group);
            var groupTag = groupsTag.method_10580(groupName);

            if (groupTag instanceof class_2499) {
                throw new UnsupportedOperationException();
            } else if (groupTag instanceof class_2487 compound) {
                group.fromTag(compound);
            }

            propagateGroup(group);
        }

    }

    public Map<String, PingspamGroupData> groups() {
        return groups;
    }

    private void propagateGroup(PingspamGroupData group) {
        for (var memberId : group.members()) {
            store.getPlayer(memberId, PingSpam.PLAYER_DATA).groups().add(group.name());
        }
    }

    public void addPlayerToGroup(String group, UUID playerId) {
        groups.computeIfAbsent(group, PingspamGroupData::new).members.add(playerId);
        store.getPlayer(playerId, PingSpam.PLAYER_DATA).groups().add(group);
    }

    public void removePlayerFromGroup(String group, UUID playerId) {
        store.getPlayer(playerId, PingSpam.PLAYER_DATA).groups().remove(group);

        PingspamGroupData groupData = groups.get(group);

        if (groupData == null) return;

        groupData.members.remove(playerId);

        if (groupData.members().size() == 0) groups.remove(group);
    }

    @Override
    public class_2487 toTag(class_2487 tag, class_7225.class_7874 registries) {
        var groupsTag = new class_2487();
        tag.method_10566("Groups", groupsTag);
        for (var entry : groups.entrySet()) {
            groupsTag.method_10566(entry.getKey(), entry.getValue().toTag(new class_2487()));
        }

        return tag;
    }
}
