package me.basiqueevangelist.pingspam.data;

import org.jetbrains.annotations.UnmodifiableView;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_4844;

public class PingspamGroupData {
    private final String name;
    final List<UUID> members = new ArrayList<>();
    private final List<UUID> membersView = Collections.unmodifiableList(members);
    private boolean pingable = true;
    private boolean hasChat = false;

    public PingspamGroupData(String name) {
        this.name = name;
    }
    public void fromTag(class_2487 tag) {
        var members = tag.method_67491("Members", class_4844.field_40825.listOf()).orElse(List.of());
        this.members.clear();
        this.members.addAll(members);

        pingable = tag.method_10577("Pingable").orElse(true);
        hasChat = tag.method_10577("HasChat").orElse(false);
    }

    public class_2487 toTag(class_2487 tag) {
        tag.method_67494("Members", class_4844.field_40825.listOf(), members);
        tag.method_10556("Pingable", pingable);
        tag.method_10556("HasChat", hasChat);

        return tag;
    }

    public @UnmodifiableView List<UUID> members() {
        return membersView;
    }

    public boolean isPingable() {
        return pingable;
    }

    public void isPingable(boolean value) {
        pingable = value;
    }

    public boolean hasChat() {
        return hasChat;
    }

    public void hasChat(boolean value) {
        hasChat = value;
    }

    public String name() {
        return name;
    }
}
