package me.basiqueevangelist.pingspam.data;

import com.mojang.serialization.Codec;
import me.basiqueevangelist.onedatastore.api.ComponentInstance;
import me.basiqueevangelist.pingspam.utils.CaseInsensitiveUtil;
import me.basiqueevangelist.pingspam.utils.CodecUtil;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public final class PingspamPlayerData implements ComponentInstance {
    private final List<class_2561> unreadPings;
    private final Set<String> aliases;
    private final List<UUID> ignoredPlayers;
    private @Nullable class_3414 pingSound;
    private final Set<String> groups;
    private @Nullable String currentChat;

    public PingspamPlayerData(
        List<class_2561> unreadPings,
        Set<String> aliases,
        List<UUID> ignoredPlayers,
        @Nullable class_3414 pingSound,
        Set<String> groups
    ) {
        this.unreadPings = unreadPings;
        this.aliases = aliases;
        this.ignoredPlayers = ignoredPlayers;
        this.pingSound = pingSound;
        this.groups = groups;
    }

    public PingspamPlayerData() {
        this(new ArrayList<>(), CaseInsensitiveUtil.setIgnoringCase(), new ArrayList<>(), class_3417.field_17265, CaseInsensitiveUtil.setIgnoringCase());
    }

    @Override
    public void fromTag(class_2487 tag, class_7225.class_7874 registries) {
        if (tag.method_10545("UnreadPings")) {
            List<class_2561> pings = tag.method_67491("UnreadPings", CodecUtil.TEXT_JSON.listOf()).orElse(List.of());
            unreadPings.addAll(pings);
        }

        if (tag.method_10545("Aliases")) {
            class_2499 aliasesTag = tag.method_68569("Aliases");
            for (class_2520 aliasTag : aliasesTag) {
                aliasTag.method_68658().ifPresent(aliases::add);
            }
        }

        if (tag.method_10545("IgnoredPlayers")) {
            List<UUID> ignoredPlayerList = tag.method_67491("IgnoredPlayers", class_4844.field_40825.listOf()).orElse(List.of());
            ignoredPlayers.addAll(ignoredPlayerList);
        }

        if (tag.method_10545("PingSound")) {
            var soundText = tag.method_10558("PingSound").orElse("null");
            if (soundText.equals("null")) {
                pingSound = null;
            } else {
                pingSound = class_7923.field_41172.method_17966(class_2960.method_60654(soundText)).orElse(class_3417.field_17265);
            }
        }

        if (tag.method_10545("CurrentChat")) {
            currentChat = tag.method_10558("CurrentChat").orElse(null);
        }
    }

    @Override
    public class_2487 toTag(class_2487 tag, class_7225.class_7874 registries) {
        if (!unreadPings.isEmpty()) {
            tag.method_67494("UnreadPings", CodecUtil.TEXT_JSON.listOf(), unreadPings);
        }

        if (!aliases.isEmpty()) {
            tag.method_67494("Aliases", Codec.STRING.listOf().xmap(LinkedHashSet::new, ArrayList::new), aliases);
        }

        if (!ignoredPlayers.isEmpty()) {
            tag.method_67494("IgnoredPlayers", class_4844.field_40825.listOf(), ignoredPlayers);
        }

        if (pingSound == null) {
            tag.method_10582("PingSound", "null");
        } else if (pingSound != class_3417.field_17265) {
            tag.method_10582("PingSound", pingSound.comp_3319().toString());
        }

        if (currentChat != null) {
            tag.method_10582("CurrentChat", currentChat);
        }

        return tag;
    }

    public void addPing(class_2561 pingMsg) {
        while (unreadPings.size() >= 100)
            unreadPings.remove(0);
        unreadPings.add(pingMsg);
    }

    public List<class_2561> unreadPings() {
        return unreadPings;
    }

    public Set<String> aliases() {
        return aliases;
    }

    public List<UUID> ignoredPlayers() {
        return ignoredPlayers;
    }

    public @Nullable class_3414 pingSound() {
        return pingSound;
    }

    public Set<String> groups() {
        return groups;
    }

    public void setPingSound(@Nullable class_3414 pingSound) {
        this.pingSound = pingSound;
    }

    public @Nullable String currentChat() {
        return currentChat;
    }

    public void currentChat(@Nullable String currentChat) {
        this.currentChat = currentChat;
    }
}
