package me.basiqueevangelist.pingspam.logic;

import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.network.ServerNetworkLogic;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public final class GroupChatLogic {
    private GroupChatLogic() {

    }

    public static void sendIn(class_3222 player, String groupName, class_7471 message) {
        // TODO: actually use secure chat.

        MinecraftServer server = player.method_5682();
        var group = DataStore.getFor(server).get(PingSpam.GLOBAL_DATA).groups().get(groupName);
        var text = class_2561.method_43470("[")
            .method_10852(class_2561.method_43470("@" + groupName)
                .method_27692(class_124.field_1054))
            .method_27693("] ")
            .method_10852(player.method_5477())
            .method_27693(": ")
            .method_10852(message.method_46291());

        PingLogic.ProcessedPing ping =
            PingLogic.processPings(server, message.method_46291(), text, player.method_5667(), group.members()::contains);

        for (var member : group.members()) {
            class_3222 online = server.method_3760().method_14602(member);
            if (online == null) continue;

            if (ping.pingSucceeded) {
                if (ping.sender == online) {
                    online.method_7353(text.method_27661().method_27692(class_124.field_1065), false);
                } else if (ping.pingedPlayers.contains(member)) {
                    online.method_7353(text.method_27661().method_27692(class_124.field_1075), false);
                }

                continue;
            }

            online.method_7353(text, false);
        }
    }

    public static void changeChat(class_3222 player, @Nullable String groupName) {
        MinecraftServer server = player.method_5682();
        var playerData = DataStore.getFor(server).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        if (Objects.equals(playerData.currentChat(), groupName)) return;

        playerData.currentChat(groupName);
        ServerNetworkLogic.sendServerAnnouncement(player, player.field_13987.field_45013);
    }
}
