package me.basiqueevangelist.pingspam.logic;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.UUID;

public final class IgnoreLogic {
    private static final SimpleCommandExceptionType IGNORED = new SimpleCommandExceptionType(class_2561.method_43470("That player is ignoring you."));

    private IgnoreLogic() {

    }

    public static boolean isIgnored(class_3222 player, UUID by) {
        if (PingspamPermissions.bypassIgnore(player)) return false;

        return DataStore.getFor(player.method_5682()).getPlayer(by, PingSpam.PLAYER_DATA).ignoredPlayers().contains(player.method_5667());
    }

    public static void throwIfIgnored(class_3222 player, UUID by) throws CommandSyntaxException {
        if (isIgnored(player, by)) {
            throw IGNORED.create();
        }
    }
}
