package me.basiqueevangelist.pingspam.logic;

import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.onedatastore.api.PlayerDataEntry;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.PingspamGroupData;
import me.basiqueevangelist.pingspam.data.PingspamPlayerData;
import me.basiqueevangelist.pingspam.utils.NameUtil;
import me.basiqueevangelist.pingspam.utils.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public final class PingLogic {
    public static final Pattern PING_PATTERN = Pattern.compile("@([\\w0-9_]{2,})", Pattern.UNICODE_CHARACTER_CLASS);

    private PingLogic() {

    }

    public static class ProcessedPing {
        public List<UUID> pingedPlayers = new ArrayList<>();
        public MinecraftServer server;
        public boolean pingSucceeded = false;
        public class_3222 sender;
        public Predicate<UUID> playerPredicate;
    }

    public static ProcessedPing processPings(MinecraftServer server, class_2561 messageContent, class_2561 message, UUID senderUuid,
                                             @Nullable Predicate<UUID> playerPredicate) {
        String contents = messageContent.getString();
        class_3222 sender = server.method_3760().method_14602(senderUuid);
        Matcher matcher = PING_PATTERN.matcher(contents);
        ProcessedPing result = new ProcessedPing();
        result.sender = sender;
        result.server = server;
        result.playerPredicate = playerPredicate == null ? unused -> true : playerPredicate;
        if (PingSpam.CONFIG.getConfig().processPingsFromUnknownPlayers || sender != null) {
            while (matcher.find()) {
                String username = matcher.group(1);
                processMention(result, username, message);
            }
        }
        return result;
    }

    private static void processMention(ProcessedPing result, String mention, class_2561 message) {
        switch (mention) {
            case "everyone":
                if (result.sender == null || PingspamPermissions.pingEveryone(result.sender)) {
                    for (UUID playerId : PlayerUtils.getAllPlayers(result.server)) {
                        pingPlayer(result, playerId, message);
                    }
                    result.pingSucceeded = true;
                } else {
                    PingLogic.sendPingError(result.sender, "You do not have enough permissions to ping @everyone!");
                }
                break;
            case "online":
                if (result.sender == null || PingspamPermissions.pingOnline(result.sender)) {
                    for (class_3222 player : result.server.method_3760().method_14571()) {
                        pingPlayer(result, player.method_5667(), message);
                    }
                    result.pingSucceeded = true;
                } else {
                    PingLogic.sendPingError(result.sender, "You do not have enough permissions to ping @online!");
                }
                break;
            case "offline":
                if (result.sender == null || PingspamPermissions.pingOffline(result.sender)) {
                    for (PlayerDataEntry entry : DataStore.getFor(result.server).players()) {
                        if (result.server.method_3760().method_14602(entry.playerId()) != null) continue;

                        pingPlayer(result, entry.playerId(), message);
                    }
                    result.pingSucceeded = true;
                } else {
                    PingLogic.sendPingError(result.sender, "You do not have enough permissions to ping @offline!");
                }
                break;
            default:
                PingspamGroupData pingGroup = DataStore.getFor(result.server).get(PingSpam.GLOBAL_DATA).groups().get(mention);
                if (pingGroup != null && pingGroup.isPingable()) {
                    if (result.sender == null || PingspamPermissions.pingGroup(result.sender)) {
                        for (UUID playerId : pingGroup.members()) {
                            pingPlayer(result, playerId, message);
                        }

                        result.pingSucceeded = true;
                    } else {
                        PingLogic.sendPingError(result.sender, "You do not have enough permissions to ping group @" + mention + "!");
                    }
                    return;
                }

                UUID foundPlayerId = PlayerUtils.tryFindPlayer(result.server, mention);

                if (foundPlayerId == null) {
                    if (result.sender != null)
                        PingLogic.sendPingError(result.sender, "No such player: " + mention + "!");
                    return;
                }

                if (!result.playerPredicate.test(foundPlayerId)) {
                    if (result.sender != null)
                        PingLogic.sendPingError(result.sender, "@" + mention + " is unreachable in this context");
                    return;
                }

                PingspamPlayerData foundData = DataStore.getFor(result.server).getPlayer(foundPlayerId, PingSpam.PLAYER_DATA);

                if (result.sender != null && !PingspamPermissions.bypassIgnore(result.sender)) {
                    if (foundData.ignoredPlayers().contains(result.sender.method_5667())) {
                        PingLogic.sendPingError(result.sender, NameUtil.getNameFromUUID(foundPlayerId) + " has ignored you, they won't receive your ping.");
                        break;
                    }
                }

                if (result.sender != null && !PingspamPermissions.pingPlayer(result.sender)) {
                    PingLogic.sendPingError(result.sender, "You do not have enough permissions to ping @" + mention + "!");
                    return;
                }

                PingLogic.pingPlayer(result, foundPlayerId, message);
                result.pingSucceeded = true;
        }
    }

    public static void pingPlayer(ProcessedPing ping, UUID playerUuid, class_2561 pingMsg) {
        if (ping.pingedPlayers.contains(playerUuid)) return;
        if (!ping.playerPredicate.test(playerUuid)) return;

        ping.pingedPlayers.add(playerUuid);
        sendNotification(ping.server, playerUuid, pingMsg);
    }

    public static void sendNotification(MinecraftServer server, UUID playerId, class_2561 pingMsg) {
        PingspamPlayerData data = DataStore.getFor(server).getPlayer(playerId, PingSpam.PLAYER_DATA);

        data.addPing(pingMsg);

        class_3222 onlinePlayer = server.method_3760().method_14602(playerId);
        if (onlinePlayer != null) {
            class_3414 pingSound = data.pingSound();

            if (pingSound != null) {
                onlinePlayer.method_17356(pingSound, class_3419.field_15248, 1.0F, 1.0F);
            }
        }
    }

    public static void sendPingError(class_3222 sender, String text) {
        if (PingSpam.CONFIG.getConfig().sendPingErrors)
            sender.method_7353(class_2561.method_43470(text).method_27692(class_124.field_1061), false);
    }
}
