package me.basiqueevangelist.pingspam.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.brigadier.tree.CommandNode;
import me.basiqueevangelist.pingspam.hack.StateTracker;
import me.basiqueevangelist.pingspam.network.ServerNetworkLogic;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2170.class)
public class CommandManagerMixin {
    @WrapOperation(method = "deepCopyNodes", at = @At(value = "INVOKE", target = "Lcom/mojang/brigadier/tree/CommandNode;canUse(Ljava/lang/Object;)Z"))
    private static boolean canUse(CommandNode<?> instance, Object source, Operation<Boolean> original) {
        StateTracker.IS_IN_COMMAND_TREE_CREATION = true;
        try {
            return original.call(instance, source);
        } finally {
            StateTracker.IS_IN_COMMAND_TREE_CREATION = false;
        }
    }

    @Inject(method = "sendCommandTree(Lnet/minecraft/server/network/ServerPlayerEntity;)V", at = @At("HEAD"))
    private void onReloadPermissions(class_3222 player, CallbackInfo ci) {
        ServerNetworkLogic.sendServerAnnouncement(player, player.field_13987.field_45013);
    }
}
