package me.basiqueevangelist.pingspam.mixin;

import me.basiqueevangelist.pingspam.logic.PingLogic;
import me.basiqueevangelist.pingspam.network.ServerNetworkLogic;
import me.basiqueevangelist.pingspam.utils.MessageTypeTransformer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2535;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.class_7463;
import net.minecraft.class_7471;
import net.minecraft.class_7604;
import net.minecraft.class_7924;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;

@Mixin(class_3324.class)
public abstract class PlayerManagerMixin {
    @Shadow @Final private MinecraftServer server;
    @Unique private PingLogic.ProcessedPing pong;

    @Inject(method = "onPlayerConnect", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/PlayerManager;sendCommandTree(Lnet/minecraft/server/network/ServerPlayerEntity;)V"))
    public void onPlayerConnected(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        ServerNetworkLogic.addPossibleName((class_3324)(Object) this, player.method_7334().getName());
    }

    @Inject(method = "broadcast(Lnet/minecraft/network/message/SignedMessage;Ljava/util/function/Predicate;Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/network/message/MessageType$Parameters;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/MinecraftServer;logChatMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageType$Parameters;Ljava/lang/String;)V", shift = At.Shift.AFTER))
    public void processPingSigned(class_7471 message, Predicate<class_3222> shouldSendFiltered, class_3222 sender, class_2556.class_7602 params, CallbackInfo ci) {
        class_7463 rule = params.comp_919().comp_349().comp_792();
        UUID uuid = sender == null ? class_156.field_25140 : sender.method_5667();

        if (rule != null) {
            pong = PingLogic.processPings(server, message.method_46291(), rule.method_43832(message.method_46291(), params), uuid, null);
        }
    }

    @Inject(method = "broadcast*", at = @At("RETURN"))
    private void deletePing(CallbackInfo ci) {
        pong = null;
    }

    @Redirect(method = "broadcast(Lnet/minecraft/network/message/SignedMessage;Ljava/util/function/Predicate;Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/network/message/MessageType$Parameters;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayerEntity;sendChatMessage(Lnet/minecraft/network/message/SentMessage;ZLnet/minecraft/network/message/MessageType$Parameters;)V"))
    private void sendMessageSigned(class_3222 player, class_7604 message, boolean filterMaskEnabled, class_2556.class_7602 params) {
        if (pong != null && pong.pingSucceeded) {
            var typeRegistry = server.method_30611().method_30530(class_7924.field_41237);
            var oldKey = typeRegistry.method_29113(params.comp_919().comp_349()).orElseThrow();
            class_5321<class_2556> newKey = null;

            if (pong.pingedPlayers.contains(player.method_5667())) {
                newKey = class_5321.method_29179(class_7924.field_41237, MessageTypeTransformer.wrapPinged(oldKey.method_29177()));
            } else if (pong.sender == player) {
                newKey = class_5321.method_29179(class_7924.field_41237, MessageTypeTransformer.wrapPingSuccessful(oldKey.method_29177()));
            }

            if (newKey != null) {
                player.method_43505(message, filterMaskEnabled, new class_2556.class_7602(typeRegistry.method_10223(newKey.method_29177()).orElseThrow(), params.comp_920(), params.comp_921()));
                return;
            }
        }

        player.method_43505(message, filterMaskEnabled, params);
    }

    @Inject(method = "broadcast(Lnet/minecraft/text/Text;Ljava/util/function/Function;Z)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/MinecraftServer;sendMessage(Lnet/minecraft/text/Text;)V", shift = At.Shift.AFTER))
    private void processPing(class_2561 message, Function<class_3222, class_2561> playerMessageFactory, boolean overlay, CallbackInfo ci) {
        if (overlay) return;

        pong = PingLogic.processPings(server, message, message, class_156.field_25140, null);
    }

    @Redirect(method = "broadcast(Lnet/minecraft/text/Text;Ljava/util/function/Function;Z)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayerEntity;sendMessageToClient(Lnet/minecraft/text/Text;Z)V"))
    private void sendMessage(class_3222 player, class_2561 message, boolean overlay) {
        if (!overlay && pong != null && pong.pingSucceeded) {
            if (pong.pingedPlayers.contains(player.method_5667())) {
                player.method_7353(message.method_27661().method_27692(class_124.field_1075), false);
            } else if (pong.sender == player) {
                player.method_7353(message.method_27661().method_27692(class_124.field_1065), false);
                pong.pingedPlayers.add(pong.sender.method_5667());
            }
        }

        if (pong == null || !pong.pingedPlayers.contains(player.method_5667()))
            player.method_7353(message, overlay);
    }
}
