package me.basiqueevangelist.pingspam.mixin;

import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.logic.GroupChatLogic;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7471;
import net.minecraft.class_8609;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3244.class)
public abstract class ServerPlayNetworkHandlerMixin extends class_8609 {
    @Shadow public class_3222 player;

    public ServerPlayNetworkHandlerMixin(MinecraftServer server, class_2535 connection, class_8792 clientData) {
        super(server, connection, clientData);
    }

    @Inject(method = "handleDecoratedMessage", at = @At("HEAD"), cancellable = true)
    private void trySendToChat(class_7471 message, CallbackInfo ci) {
        if (!PingSpam.CONFIG.getConfig().groupChatsEnabled) return;

        String currentChat = DataStore.getFor(field_45012).getPlayer(player.method_5667(), PingSpam.PLAYER_DATA).currentChat();

        if (currentChat != null) {
            GroupChatLogic.sendIn(player, currentChat, message);
            ci.cancel();
        }
    }
}
