package me.basiqueevangelist.pingspam.mixin;

import com.mojang.authlib.GameProfile;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.data.PingspamPlayerData;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends class_1657 {
    @Unique private static final int ACTIONBAR_TIME = 10;

    public ServerPlayerEntityMixin(class_1937 world, GameProfile profile) {
        super(world, profile);
    }

    @Shadow public abstract void method_7353(class_2561 message, boolean actionBar);

    @Unique private PingspamPlayerData pingspamData;
    @Unique private int actionbarTime = 0;
    @Unique private int prevPingsCount = -1;

    @Inject(method = "<init>", at = @At("RETURN"))
    private void loadPingspamData(MinecraftServer server, class_3218 world, GameProfile profile, class_8791 clientOptions, CallbackInfo ci) {
        if (isSus()) return;

        pingspamData = DataStore.getFor(server).getPlayer(field_6021, PingSpam.PLAYER_DATA);
    }

    @Inject(method = "tick", at = @At("TAIL"))
    private void tick(CallbackInfo ci) {
        if (isSus()) return;

        var pings = pingspamData.unreadPings();

        if (prevPingsCount != pings.size()) {
            prevPingsCount = pings.size();
            actionbarTime = 0;
        }

        if (pings.size() > 0 && PingSpam.CONFIG.getConfig().showUnreadMessagesInActionbar) {
            actionbarTime--;

            if (actionbarTime <= 0) {
                actionbarTime = ACTIONBAR_TIME;
                method_7353(
                    class_2561.method_43470("You have " + pings.size() + " unread message" + (pings.size() != 1 ? "s" : "") + "."),
                    true
                );
            }
        } else {
            actionbarTime = 0;
        }
    }

    @Inject(method = "sendMessage(Lnet/minecraft/text/Text;Z)V", at = @At("HEAD"))
    private void onActionbarMessage(class_2561 message, boolean actionBar, CallbackInfo ci) {
        if (actionBar)
            actionbarTime = 40;
    }

    @SuppressWarnings("ConstantConditions")
    @Unique
    private boolean isSus() {
        return (Class<?>) getClass() != class_3222.class;
    }
}
