package me.basiqueevangelist.pingspam.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_9139;

public final class PacketVersionSwitch<B extends class_2540, V> {
    private final Int2ObjectMap<class_9139<B, V>> versions = new Int2ObjectOpenHashMap<>();
    private int latestVersion = -1;

    public PacketVersionSwitch<B, V> version(int version, class_9139<B, V> alternative) {
        versions.put(version, alternative);

        if (latestVersion < version) latestVersion = version;

        return this;
    }

    public class_9139<B, V> build() {
        var supported = versions.keySet().intStream().mapToObj(Integer::toString).collect(Collectors.joining(", "));

        return new class_9139<>() {
            @Override
            public V decode(B buf) {
                int version = buf.method_10816();

                var codec = versions.get(version);
                if (codec == null) {
                    throw new IllegalStateException("Received packet of version " + version + ", but only versions " + supported + " are supported!");
                }

                return codec.decode(buf);
            }

            @Override
            public void encode(B buf, V value) {
                buf.method_10804(latestVersion);

                versions.get(latestVersion).encode(buf, value);
            }
        };
    }
}
