package me.basiqueevangelist.pingspam.network;

import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.pingspam.PingSpam;
import me.basiqueevangelist.pingspam.logic.NameLogic;
import me.basiqueevangelist.pingspam.logic.PingspamPermissions;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8710;
import java.util.List;
import java.util.Set;

public final class ServerNetworkLogic {
    private ServerNetworkLogic() {

    }

    public static void sendServerAnnouncement(class_3222 player, class_2535 conn) {
        DataStore store = DataStore.getFor(player.method_51469().method_8503());
        var data = store.getPlayer(player.method_5667(), PingSpam.PLAYER_DATA);

        class_2540 newBuf = PacketByteBufs.create();

        Set<String> possibleNames;
        var group = data.currentChat() == null ? null : store.get(PingSpam.GLOBAL_DATA).groups().get(data.currentChat());

        if (group != null) {
            possibleNames = NameLogic.listValidNames(player.method_5682(), group.members()::contains, false);
        } else {
            possibleNames = NameLogic.listValidNames(player.method_5682(), uuid -> true, true);
        }

        newBuf.method_34062(possibleNames, class_2540::method_10814);

        var payload = new AnnounceS2CPayload(
            PingspamPermissions.pingEveryone(player),
            PingspamPermissions.pingOnline(player),
            PingspamPermissions.pingOffline(player),
            PingspamPermissions.pingPlayer(player),
            possibleNames
        );

        conn.method_10743(ServerPlayNetworking.createS2CPacket(payload));
    }

    public static void removePossibleName(class_3324 manager, String possibleName) {
        sendToAll(manager, new PossibleNamesDiffS2CPacket(List.of(), List.of(possibleName)));
    }

    public static void addPossibleName(class_3324 manager, String possibleName) {
        sendToAll(manager, new PossibleNamesDiffS2CPacket(List.of(possibleName), List.of()));
    }

    public static void sendToAll(class_3324 manager, class_8710 payload) {
        class_2596<?> packet = ServerPlayNetworking.createS2CPacket(payload);
        for (class_3222 player : manager.method_14571()) {
            if (ServerPlayNetworking.canSend(player, payload.method_56479()) || PingSpam.CONFIG.getConfig().ignoreCanSend)
                player.field_13987.method_14364(packet);
        }
    }
}
