package me.basiqueevangelist.pingspam.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.onedatastore.api.PlayerDataEntry;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class CommandUtil {
    private static final SimpleCommandExceptionType TOO_MANY_PLAYERS = new SimpleCommandExceptionType(class_2561.method_43470("Can't mention many players at once!"));

    private CommandUtil() {

    }

    public static GameProfile getOnePlayer(CommandContext<class_2168> ctx, String argName) throws CommandSyntaxException {
        Collection<GameProfile> profiles = class_2191.method_9330(ctx, "player");

        if (profiles.size() > 1)
            throw TOO_MANY_PLAYERS.create();

        return profiles.iterator().next();
    }

    public static CompletableFuture<Suggestions> suggestPlayersExceptSelf(CommandContext<class_2168> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        var playerNames = new HashSet<>(List.of(ctx.getSource().method_9211().method_3858()));

        for (PlayerDataEntry entry : DataStore.getFor(src.method_9211()).players()) {
            String name = NameUtil.getNameFromUUIDOrNull(entry.playerId());

            if (name == null) continue;

            playerNames.add(name);
        }

        playerNames.remove(ctx.getSource().method_9207().method_5820());

        return class_2172.method_9265(playerNames, builder);
    }

    public static CompletableFuture<Suggestions> suggestPlayers(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        class_2168 src = ctx.getSource();
        var playerNames = new HashSet<>(List.of(ctx.getSource().method_9211().method_3858()));

        for (PlayerDataEntry entry : DataStore.getFor(src.method_9211()).players()) {
            String name = NameUtil.getNameFromUUIDOrNull(entry.playerId());

            if (name == null) continue;

            playerNames.add(name);
        }

        return class_2172.method_9265(playerNames, builder);
    }
}
