package me.basiqueevangelist.pingspam.utils;

import me.basiqueevangelist.pingspam.PingSpam;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_4284;
import net.minecraft.class_5218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;

public final class OfflineUtil {
    private final static Logger LOGGER = LoggerFactory.getLogger("Pingspam/OfflineUtil");

    private OfflineUtil() {

    }

    // Directly copied from NeVSeti/OwO Offline API

    public static class_2487 get(UUID player) throws IOException {
        Path savedPlayersPath = PingSpam.SERVER.method_27050(class_5218.field_24182);
        Path savedDataPath = savedPlayersPath.resolve(player.toString() + ".dat");
        class_2487 rawTag = class_2507.method_30613(savedDataPath, class_2505.method_53898());
        return class_4284.field_19213.method_48130(
            PingSpam.SERVER.method_3855(),
            rawTag,
            class_2512.method_48309(rawTag, -1)
        );
    }

    public static List<UUID> listSavedPlayers() {
        List<UUID> list = new ArrayList<>();
        Path savedPlayersPath = PingSpam.SERVER.method_27050(class_5218.field_24182);

        try (Stream<Path> stream = Files.list(savedPlayersPath)) {
            for (Path savedPlayerFile : (Iterable<? extends Path>) stream::iterator) {
                if (Files.isDirectory(savedPlayerFile) || !savedPlayerFile.toString().endsWith(".dat")) {
                    continue;
                }

                try {
                    String filename = savedPlayerFile.getFileName().toString();
                    String uuidStr = filename.substring(0, filename.lastIndexOf('.'));
                    UUID uuid = UUID.fromString(uuidStr);
                    list.add(uuid);
                } catch (IllegalArgumentException iae) {
                    LOGGER.error("Encountered invalid UUID in playerdata directory! ", iae);
                }
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        return list;
    }
}
