package me.basiqueevangelist.pingspam.utils;

import me.basiqueevangelist.onedatastore.api.DataStore;
import me.basiqueevangelist.onedatastore.api.PlayerDataEntry;
import me.basiqueevangelist.pingspam.PingSpam;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public final class PlayerUtils {
    private PlayerUtils() {

    }

    public static @Nullable UUID tryFindPlayer(MinecraftServer server, String name) {
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player.method_7334().getName().equalsIgnoreCase(name))
                return player.method_5667();
        }

        for (PlayerDataEntry entry : DataStore.getFor(server).players()) {
            if (NameUtil.getNameFromUUID(entry.playerId()).equalsIgnoreCase(name))
                return entry.playerId();

            if (entry.get(PingSpam.PLAYER_DATA).aliases().contains(name))
                return entry.playerId();
        }

        return null;
    }

    public static Set<UUID> getAllPlayers(MinecraftServer server) {
        Set<UUID> players = new HashSet<>();

        for (class_3222 player : server.method_3760().method_14571()) {
            players.add(player.method_5667());
        }

        for (PlayerDataEntry entry : DataStore.getFor(server).players()) {
            players.add(entry.playerId());
        }

        return players;
    }
}
