/*
 * Decompiled with CFR 0.152.
 */
package com.knightsheraldry;

import banduty.stoneycore.event.custom.RenderOverlayAndAdditionsEvents;
import com.knightsheraldry.client.entity.KHBodkinArrowEntityRenderer;
import com.knightsheraldry.client.entity.KHBroadheadArrowEntityRenderer;
import com.knightsheraldry.client.entity.KHClothArrowEntityRenderer;
import com.knightsheraldry.client.entity.KHSwallowtailArrowEntityRenderer;
import com.knightsheraldry.client.entity.WarDartRenderer;
import com.knightsheraldry.entity.ModEntities;
import com.knightsheraldry.event.ItemTooltipHandler;
import com.knightsheraldry.event.RenderFirstPersonAccessoryArmorHandler;
import com.knightsheraldry.event.RenderOverlayAndAdditionsHandler;
import com.knightsheraldry.items.ModItems;
import com.knightsheraldry.items.armor.accessory.KHChaperon;
import com.knightsheraldry.items.armor.horse.HorseBardingArmorItem;
import com.knightsheraldry.items.item.DyeableItems;
import com.knightsheraldry.items.item.TwoLayerDyeableItem;
import com.knightsheraldry.model.HorseBardingModel;
import com.knightsheraldry.model.ModEntityModelLayers;
import com.knightsheraldry.networking.ModMessages;
import com.knightsheraldry.util.itemdata.ItemTooltipComponent;
import com.knightsheraldry.util.itemdata.ItemTooltipData;
import com.knightsheraldry.util.itemdata.ModModelPredicates;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.platform.Platform;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_5601;
import net.minecraft.class_7923;

public class KnightsHeraldryClient
implements ClientModInitializer {
    @Environment(value=EnvType.CLIENT)
    public void onInitializeClient() {
        ModMessages.registerS2CPackets();
        ItemTooltipCallback.EVENT.register((Object)new ItemTooltipHandler());
        RenderOverlayAndAdditionsEvents.EVENT.register((Object)new RenderOverlayAndAdditionsHandler());
        RenderFirstPersonAccessoryArmorHandler.EVENT.register((Object)new RenderFirstPersonAccessoryArmorHandler());
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof ItemTooltipData) {
                ItemTooltipData itemData = (ItemTooltipData)data;
                return new ItemTooltipComponent(itemData.items());
            }
            return null;
        });
        if (Platform.isForge()) {
            ClientLifecycleEvent.CLIENT_SETUP.register(minecraftClient -> this.registerClient());
        } else {
            this.registerClient();
        }
        EntityModelLayerRegistry.registerModelLayer((class_5601)ModEntityModelLayers.HORSE_BARDING_MODEL_LAYER, HorseBardingModel::getTexturedModelData);
    }

    private void registerClient() {
        EntityRendererRegistry.register((class_1299)((class_1299)ModEntities.WARDART_PROJECTILE.get()), WarDartRenderer::new);
        for (class_1792 item : class_7923.field_41178) {
            if (item == ModItems.SWALLOWTAIL_ARROW.get()) {
                EntityRendererRegistry.register((class_1299)((class_1299)ModEntities.SWALLOWTAIL_ARROW.get()), KHSwallowtailArrowEntityRenderer::new);
            }
            if (item == ModItems.BODKIN_ARROW.get()) {
                EntityRendererRegistry.register((class_1299)((class_1299)ModEntities.BODKING_ARROW.get()), KHBodkinArrowEntityRenderer::new);
            }
            if (item == ModItems.BROADHEAD_ARROW.get()) {
                EntityRendererRegistry.register((class_1299)((class_1299)ModEntities.BROADHEAD_ARROW.get()), KHBroadheadArrowEntityRenderer::new);
            }
            if (item == ModItems.CLOTH_ARROW.get()) {
                EntityRendererRegistry.register((class_1299)((class_1299)ModEntities.CLOTH_ARROW.get()), KHClothArrowEntityRenderer::new);
            }
            if (item instanceof TwoLayerDyeableItem) {
                TwoLayerDyeableItem twoLayerItem = (TwoLayerDyeableItem)item;
                ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
                    if (tintIndex == 0) {
                        return twoLayerItem.getColor1(stack);
                    }
                    if (tintIndex == 1) {
                        return twoLayerItem.getColor2(stack);
                    }
                    return -1;
                }, (Object[])new class_1935[]{item});
            }
            if (item instanceof DyeableItems) {
                DyeableItems dyeableItems = (DyeableItems)item;
                ColorProviderRegistry.ITEM.register((stack, tintIndex) -> tintIndex > 0 ? -1 : dyeableItems.method_7800(stack), (Object[])new class_1935[]{item});
            }
            if (item instanceof HorseBardingArmorItem) {
                HorseBardingArmorItem horseBardingArmorItem = (HorseBardingArmorItem)item;
                ColorProviderRegistry.ITEM.register((stack, tintIndex) -> tintIndex > 0 ? -1 : horseBardingArmorItem.method_7800(stack), (Object[])new class_1935[]{item});
            }
            if (item instanceof KHChaperon) {
                KHChaperon khChaperon = (KHChaperon)item;
                ColorProviderRegistry.ITEM.register((stack, tintIndex) -> tintIndex > 0 ? -1 : khChaperon.method_7800(stack), (Object[])new class_1935[]{item});
            }
            if (!Objects.equals(class_7923.field_41178.method_10221((Object)item).method_12836(), "knightsheraldry")) continue;
            ModModelPredicates.registerModelPredicates(item);
        }
    }
}

