/*
 * Decompiled with CFR 0.152.
 */
package com.knightsheraldry.event;

import banduty.stoneycore.event.custom.RenderOverlayAndAdditionsEvents;
import banduty.stoneycore.items.armor.SCAccessoryItem;
import com.knightsheraldry.items.ModItems;
import com.knightsheraldry.model.HelmetDecoModel;
import com.knightsheraldry.util.itemdata.HelmetDeco;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class RenderOverlayAndAdditionsHandler
implements RenderOverlayAndAdditionsEvents {
    private static final float[] WHITE_COLOR = new float[]{1.0f, 1.0f, 1.0f};
    private static final float ALPHA = 1.0f;
    private static final class_2960 RIM_GUARDS_TEXTURE = new class_2960("knightsheraldry", "textures/entity/accessories/rim_guards.png");
    private static final class_2960 BESAGEWS_TEXTURE = new class_2960("knightsheraldry", "textures/entity/accessories/besagews.png");
    private static final class_2960 SURCOAT_OVERLAY_TEXTURE = new class_2960("knightsheraldry", "textures/entity/accessories/surcoat_overlay.png");
    private static final class_2960 CIVILIAN_BELT_TEXTURE = new class_2960("knightsheraldry", "textures/entity/accessories/civilian_belt.png");

    public void onRenderOverlayAndAdditionsEvents(class_1309 entity, class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_572<class_1309> model) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof SCAccessoryItem)) {
            return;
        }
        SCAccessoryItem scAccessoryItem = (SCAccessoryItem)class_17922;
        this.renderHelmetDecoIfNeeded(entity, stack, matrices, vertexConsumers, light);
        this.renderPartIfNeeded(stack, matrices, vertexConsumers, light, model, "rimmed", RIM_GUARDS_TEXTURE);
        this.renderPartIfNeeded(stack, matrices, vertexConsumers, light, model, "besagews", BESAGEWS_TEXTURE);
        if (this.isSurcoat(stack)) {
            ArmorRenderer.renderPart((class_4587)matrices, (class_4597)vertexConsumers, (int)light, (class_1799)stack, model, (class_2960)SURCOAT_OVERLAY_TEXTURE);
        }
        if (stack.method_7909() == ModItems.CIVILIAN_SURCOAT.get() || stack.method_7909() == ModItems.GIORNEA.get()) {
            ArmorRenderer.renderPart((class_4587)matrices, (class_4597)vertexConsumers, (int)light, (class_1799)stack, model, (class_2960)CIVILIAN_BELT_TEXTURE);
        }
        if (scAccessoryItem.getRenderSettings(stack).overlay()) {
            ArmorRenderer.renderPart((class_4587)matrices, (class_4597)vertexConsumers, (int)light, (class_1799)stack, model, (class_2960)this.getIdentifierWithSuffix("_overlay", stack));
        }
    }

    private void renderHelmetDecoIfNeeded(class_1309 entity, class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return;
        }
        String basePath = "textures/entity/accessories/deco/";
        for (HelmetDeco deco : HelmetDeco.HELMET_DECO.values()) {
            class_2960 texture;
            float[] color;
            String key = deco.getNbtKey();
            if (deco.color() == 2) {
                if (nbt.method_10545(key) && nbt.method_10562(key).method_10545("color1")) {
                    color = this.getColorFromNbt(nbt.method_10562(key).method_10550("color1"));
                    texture = new class_2960("knightsheraldry", basePath + key + "_base.png");
                    this.renderHelmetDeco(entity, matrices, vertexConsumers, light, texture, color);
                }
                if (!nbt.method_10545(key) || !nbt.method_10562(key).method_10545("color2")) continue;
                color = this.getColorFromNbt(nbt.method_10562(key).method_10550("color2"));
                texture = new class_2960("knightsheraldry", basePath + key + "_stripe.png");
                this.renderHelmetDeco(entity, matrices, vertexConsumers, light, texture, color);
                continue;
            }
            if (!nbt.method_10545(key)) continue;
            color = deco.color() == 1 ? this.getColorFromNbt(nbt.method_10550(key)) : WHITE_COLOR;
            texture = new class_2960("knightsheraldry", basePath + key + ".png");
            this.renderHelmetDeco(entity, matrices, vertexConsumers, light, texture, color);
        }
    }

    private void renderHelmetDeco(class_1309 entity, class_4587 matrices, class_4597 vertexConsumers, int light, class_2960 texture, float[] color) {
        HelmetDecoModel model = new HelmetDecoModel(HelmetDecoModel.getTexturedModelData().method_32109());
        class_4588 consumer = vertexConsumers.getBuffer(class_1921.method_25448((class_2960)texture));
        this.renderModel(entity, model, matrices, consumer, light, color);
    }

    private void renderModel(class_1309 entity, class_572<class_1309> model, class_4587 matrices, class_4588 consumer, int light, float[] color) {
        AccessoryRenderer.followBodyRotations((class_1309)entity, model);
        model.method_2828(matrices, consumer, light, class_4608.field_21444, color[0], color[1], color[2], 1.0f);
    }

    private void renderPartIfNeeded(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_572<class_1309> model, String key, class_2960 texture) {
        if (stack.method_7948().method_10577(key)) {
            String stackName = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832();
            if (stackName.contains("dark_")) {
                if (texture.equals((Object)RIM_GUARDS_TEXTURE)) {
                    texture = new class_2960("knightsheraldry", "textures/entity/accessories/dark_rim_guards.png");
                } else if (texture.equals((Object)BESAGEWS_TEXTURE)) {
                    texture = new class_2960("knightsheraldry", "textures/entity/accessories/dark_besagews.png");
                }
            }
            ArmorRenderer.renderPart((class_4587)matrices, (class_4597)vertexConsumers, (int)light, (class_1799)stack, model, (class_2960)texture);
        }
    }

    private boolean isSurcoat(class_1799 stack) {
        return stack.method_7909() == ModItems.SURCOAT.get() || stack.method_7909() == ModItems.SURCOAT_SLEEVELESS.get();
    }

    private float[] getColorFromNbt(int colorInt) {
        return new float[]{(float)(colorInt >> 16 & 0xFF) / 255.0f, (float)(colorInt >> 8 & 0xFF) / 255.0f, (float)(colorInt & 0xFF) / 255.0f};
    }

    private class_2960 getIdentifierWithSuffix(String suffix, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof SCAccessoryItem)) {
            return new class_2960("");
        }
        SCAccessoryItem item = (SCAccessoryItem)class_17922;
        String path = item.getTexturePath(stack).method_12832().replace(".png", "") + suffix + ".png";
        return new class_2960(item.getTexturePath(stack).method_12836(), path);
    }
}

