/*
 * Decompiled with CFR 0.152.
 */
package com.knightsheraldry.util.loottable;

import com.knightsheraldry.items.ModItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public class VillagerTradesModifier {
    private static final Map<class_3852, Map<Integer, List<class_3853.class_1652>>> PROFESSION_TO_LEVELED_TRADE = new HashMap<class_3852, Map<Integer, List<class_3853.class_1652>>>();

    public static void registerCustomTrades() {
        PROFESSION_TO_LEVELED_TRADE.clear();
        VillagerTradesModifier.registerArmorerTrades();
        VillagerTradesModifier.registerWeaponsmithTrades();
        VillagerTradesModifier.registerShepherdTrades();
        VillagerTradesModifier.registerFletcherTrades();
        for (Map.Entry<class_3852, Map<Integer, List<class_3853.class_1652>>> professionEntry : PROFESSION_TO_LEVELED_TRADE.entrySet()) {
            class_3852 profession = professionEntry.getKey();
            for (Map.Entry<Integer, List<class_3853.class_1652>> levelEntry : professionEntry.getValue().entrySet()) {
                int level = levelEntry.getKey();
                List<class_3853.class_1652> offers = levelEntry.getValue();
                TradeOfferHelper.registerVillagerOffers((class_3852)profession, (int)level, factories -> factories.addAll(offers));
            }
        }
    }

    private static void addTrade(class_3852 profession, int level, class_3853.class_1652 factory) {
        PROFESSION_TO_LEVELED_TRADE.computeIfAbsent(profession, p -> new HashMap()).computeIfAbsent(level, l -> new ArrayList()).add(factory);
    }

    private static void addTradeOffer(class_3852 profession, int level, int emeraldCount, int maxUses, int xp, class_1792 item) {
        VillagerTradesModifier.addTrade(profession, level, (entity, random) -> new class_1914(new class_1799((class_1935)class_1802.field_8687, emeraldCount), new class_1799((class_1935)item, 1), maxUses, xp, 0.05f));
    }

    private static void addRandomTradeOffer(class_3852 profession, int level, int emeraldCount, int maxUses, int xp, class_1792 ... items) {
        VillagerTradesModifier.addTrade(profession, level, (entity, random) -> {
            class_1792 item = items[random.method_43048(items.length)];
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, emeraldCount), new class_1799((class_1935)item, 1), maxUses, xp, 0.05f);
        });
    }

    private static void registerArmorerTrades() {
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 1, 8, 12, 1, (class_1792)ModItems.QUILTED_COIF.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 1, 11, 12, 1, (class_1792)ModItems.GAMBESON.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 1, 8, 12, 1, (class_1792)ModItems.GAMBESON_BREECHES.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 1, 6, 12, 1, (class_1792)ModItems.GAMBESON_BOOTS.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 2, 9, 12, 5, (class_1792)ModItems.MAIL_COIF.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 2, 14, 12, 5, (class_1792)ModItems.HAUBERK.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 2, 11, 12, 5, (class_1792)ModItems.MAIL_BREECHES.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 2, 9, 12, 5, (class_1792)ModItems.MAIL_BOOTS.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 2, 8, 12, 5, (class_1792)ModItems.MAIL_PAULDRON.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 2, 9, 12, 5, (class_1792)ModItems.AVENTAIL.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 3, 23, 12, 10, (class_1792)ModItems.BRIGANDINE.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 3, 11, 12, 10, (class_1792)ModItems.GAUNTLET.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 3, 12, 12, 15, (class_1792)ModItems.HORSE_BARDING.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17052, 3, 9, 12, 10, (class_1792)ModItems.BASCINET_NO_VISOR.get(), (class_1792)ModItems.KETTLE_HELM.get(), (class_1792)ModItems.NASAL_HELM.get(), (class_1792)ModItems.VIKING_HELM.get(), (class_1792)ModItems.BARBUTE_NO_VISOR.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 4, 15, 12, 15, (class_1792)ModItems.BRIGANDINE_PAULDRON.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 4, 21, 12, 15, (class_1792)ModItems.BRIGANDINE_REREBRACE.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 4, 21, 12, 15, (class_1792)ModItems.BRIGANDINE_CHAUSSES.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17052, 4, 24, 12, 15, (class_1792)ModItems.ARMET_2.get(), (class_1792)ModItems.BARBUTE.get(), (class_1792)ModItems.BASCINET.get(), (class_1792)ModItems.CAGE.get(), (class_1792)ModItems.CAGE_2.get(), (class_1792)ModItems.FLAT_BASCINET.get(), (class_1792)ModItems.GREAT_HELM.get(), (class_1792)ModItems.GREAT_HELM_2.get(), (class_1792)ModItems.SALLET.get(), (class_1792)ModItems.ARMET.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 5, 18, 12, 15, (class_1792)ModItems.PLATE_PAULDRON.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 5, 13, 12, 15, (class_1792)ModItems.GREAVES.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 5, 11, 12, 15, (class_1792)ModItems.SABATONS.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 5, 24, 12, 15, (class_1792)ModItems.PLATE_REREBRACE.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 5, 15, 12, 15, (class_1792)ModItems.PLATE_CUISSES.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 5, 4, 12, 15, (class_1792)ModItems.RIM_GUARDS.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17052, 5, 3, 12, 15, (class_1792)ModItems.BESAGEWS.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17052, 5, 26, 12, 15, (class_1792)ModItems.BRIG_BREASTPLATE.get(), (class_1792)ModItems.BRIG_BREASTPLATE_TASSETS.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17052, 5, 26, 12, 15, (class_1792)ModItems.PLATE_CUIRASS_TASSETS.get(), (class_1792)ModItems.MAXIMILLIAN_CUIRASS.get(), (class_1792)ModItems.MAXIMILLIAN_CUIRASS_TASSETS.get(), (class_1792)ModItems.XIIII_PLATE_CUIRASS.get(), (class_1792)ModItems.XIIII_PLATE_CUIRASS_TASSETS.get(), (class_1792)ModItems.XIIII_PLATE_BREASTPLATE.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17052, 5, 24, 12, 15, (class_1792)ModItems.FROGMOUTH.get(), (class_1792)ModItems.GREAT_ARMET.get(), (class_1792)ModItems.GREAT_ARMET_2.get(), (class_1792)ModItems.GREAT_HOUNDSKUL_BASCINET.get(), (class_1792)ModItems.MAXIMILLIAN_HELMET.get());
    }

    private static void registerWeaponsmithTrades() {
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 1, 8, 12, 1, (class_1792)ModItems.PITCHFORK.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 1, 8, 12, 1, (class_1792)ModItems.SPEAR.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17065, 1, 13, 12, 1, (class_1792)ModItems.AXE.get(), (class_1792)ModItems.BROAD_AXE.get(), (class_1792)ModItems.CROOKED_AXE.get(), (class_1792)ModItems.STRAIGHT_CROOKED_AXE.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 1, 5, 12, 1, (class_1792)ModItems.DAGGER.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17065, 2, 18, 12, 5, (class_1792)ModItems.SWORD.get(), (class_1792)ModItems.V_SWORD.get(), (class_1792)ModItems.ARMING_SWORD.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17065, 2, 13, 12, 5, (class_1792)ModItems.MACE.get(), (class_1792)ModItems.SPIKED_MACE.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17065, 2, 15, 12, 5, (class_1792)ModItems.FLAIL.get(), (class_1792)ModItems.BALL_FLAIL.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17065, 2, 13, 12, 5, (class_1792)ModItems.HAMMER.get(), (class_1792)ModItems.WAR_HAMMER.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 2, 20, 12, 5, (class_1792)ModItems.WARDART.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 3, 15, 12, 10, (class_1792)ModItems.BILLHOOK.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17065, 3, 30, 12, 10, (class_1792)ModItems.LONGSWORD.get(), (class_1792)ModItems.V_LONGSWORD.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17065, 3, 15, 12, 10, (class_1792)ModItems.GLAIVE.get(), (class_1792)ModItems.CURVED_GLAIVE.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 3, 13, 12, 10, (class_1792)ModItems.LANCE.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 3, 5, 12, 10, (class_1792)ModItems.STILETTO.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 4, 23, 12, 15, (class_1792)ModItems.POLEAXE.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17065, 4, 23, 12, 15, (class_1792)ModItems.POLEHAMMER.get(), (class_1792)ModItems.BEC_DE_CORBIN.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17065, 4, 35, 12, 15, (class_1792)ModItems.WARSWORD.get(), (class_1792)ModItems.WARSWORD_CLAYMORE.get(), (class_1792)ModItems.WARSWORD_FLAMBERGE.get(), (class_1792)ModItems.WARSWORD_ZWEIHANDER.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 4, 15, 12, 15, (class_1792)ModItems.RAPIER.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 4, 20, 12, 15, (class_1792)ModItems.MORNING_STAR.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 4, 18, 12, 15, (class_1792)ModItems.HANDGONNE.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 5, 18, 12, 15, (class_1792)ModItems.HALBERD.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 5, 18, 12, 15, (class_1792)ModItems.BARDICHE.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17065, 5, 25, 12, 15, (class_1792)ModItems.ARQUEBUS.get());
    }

    private static void registerShepherdTrades() {
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17063, 1, 6, 32, 1, (class_1792)ModItems.CLOAK.get(), (class_1792)ModItems.TORN_CLOAK.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17063, 1, 15, 32, 1, (class_1792)ModItems.HOOD.get(), (class_1792)ModItems.TORN_HOOD.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17063, 1, 30, 12, 5, (class_1792)ModItems.HELMET_HOOD.get(), (class_1792)ModItems.HELMET_TORN_HOOD.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17063, 1, 1, 32, 1, (class_1792)ModItems.CHAPERON.get());
        VillagerTradesModifier.addRandomTradeOffer(class_3852.field_17063, 2, 2, 32, 1, (class_1792)ModItems.SURCOAT.get(), (class_1792)ModItems.SURCOAT_SLEEVELESS.get(), (class_1792)ModItems.CIVILIAN_SURCOAT.get(), (class_1792)ModItems.GIORNEA.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17063, 4, 20, 12, 5, (class_1792)ModItems.JESTER_HOOD.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17063, 5, 32, 12, 15, (class_1792)ModItems.GILDED_CHAPERON.get());
    }

    private static void registerFletcherTrades() {
        VillagerTradesModifier.addTradeOffer(class_3852.field_17058, 1, 1, 32, 1, (class_1792)ModItems.BROADHEAD_ARROW.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17058, 2, 2, 32, 5, (class_1792)ModItems.SWALLOWTAIL_ARROW.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17058, 2, 4, 32, 5, (class_1792)ModItems.BODKIN_ARROW.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17058, 2, 13, 12, 5, (class_1792)ModItems.LONGBOW.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17058, 3, 6, 32, 5, (class_1792)ModItems.CLOTH_ARROW.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17058, 3, 15, 12, 10, (class_1792)ModItems.HEAVY_CROSSBOW.get());
        VillagerTradesModifier.addTradeOffer(class_3852.field_17058, 4, 3, 12, 5, (class_1792)ModItems.PLUME.get());
    }
}

