/*
 * Decompiled with CFR 0.152.
 */
package com.knightsheraldry.entity.custom;

import banduty.stoneycore.entity.custom.SCArrowEntity;
import com.knightsheraldry.data.ArrowBehavior;
import com.knightsheraldry.data.ArrowBehaviorManager;
import com.knightsheraldry.entity.ModEntities;
import com.knightsheraldry.items.ModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7923;

public class KHClothArrowEntity
extends SCArrowEntity {
    private int groundTicks = 0;
    private boolean blockCollisioned = false;

    public KHClothArrowEntity(class_1309 shooter, class_1937 world) {
        super((class_1299)ModEntities.CLOTH_ARROW.get(), shooter, world);
    }

    public KHClothArrowEntity(class_1299<KHClothArrowEntity> khClothArrowEntityEntityType, class_1937 world) {
        super(khClothArrowEntityEntityType, world);
    }

    protected class_1799 method_7445() {
        return new class_1799((class_1935)ModItems.CLOTH_ARROW.get());
    }

    private ArrowBehavior getBehavior() {
        ArrowBehavior behavior = ArrowBehaviorManager.INSTANCE.getBehavior(class_7923.field_41178.method_10221((Object)((class_1792)ModItems.CLOTH_ARROW.get())));
        if (behavior == null) {
            behavior = new ArrowBehavior();
            behavior.targetItemId = class_7923.field_41178.method_10221((Object)((class_1792)ModItems.CLOTH_ARROW.get()));
            behavior.requireOnFire = true;
            behavior.groundBurnTicks = 100;
            behavior.aoeRadius = 5.0;
            ArrowBehavior.EffectEntry nausea = new ArrowBehavior.EffectEntry();
            nausea.id = new class_2960("minecraft", "nausea");
            nausea.duration = 100;
            nausea.amplifier = 0;
            ArrowBehavior.EffectEntry poison = new ArrowBehavior.EffectEntry();
            poison.id = new class_2960("minecraft", "poison");
            poison.duration = 100;
            poison.amplifier = 0;
            behavior.effects.add(nausea);
            behavior.effects.add(poison);
            behavior.smoke.enabled = true;
            behavior.smoke.particle = new class_2960("minecraft", "campfire_cosy_smoke");
            behavior.smoke.count = 80;
            behavior.smoke.maxSpeed = 0.1;
            behavior.igniteBlocks.radiusX = 2;
            behavior.igniteBlocks.radiusY = 2;
            behavior.igniteBlocks.radiusZ = 2;
            behavior.igniteBlocks.chance = 0.1f;
        }
        return behavior;
    }

    protected void onSCEntityHit(class_3966 entityHitResult) {
        super.onSCEntityHit(entityHitResult);
        class_1297 class_12972 = entityHitResult.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            this.scHitEntity(target, new class_1799((class_1935)ModItems.CLOTH_ARROW.get()), this.method_7448());
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        class_1937 world = this.method_37908();
        ArrowBehavior behavior = this.getBehavior();
        this.blockCollisioned = true;
        if ((!behavior.requireOnFire || this.method_5809()) && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (behavior.smoke.enabled) {
                this.spawnSmokeParticles(serverWorld, blockHitResult, behavior);
            }
            this.applySmokeEffectsToNearbyEntities(world, behavior);
            this.igniteNearbyBlocks(serverWorld, blockHitResult.method_17777(), behavior);
        }
        super.method_24920(blockHitResult);
    }

    public void method_5773() {
        super.method_5773();
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        ArrowBehavior behavior = this.getBehavior();
        if ((!behavior.requireOnFire || this.method_5809()) && this.blockCollisioned) {
            if (this.groundTicks >= behavior.groundBurnTicks) {
                this.method_33572(false);
                this.method_20803(0);
                this.method_5639(0);
            } else {
                ++this.groundTicks;
            }
            this.applySmokeEffectsToNearbyEntities((class_1937)serverWorld, behavior);
        }
    }

    private void spawnSmokeParticles(class_3218 serverWorld, class_3965 blockHitResult, ArrowBehavior behavior) {
        class_2338 center = blockHitResult.method_17777();
        int particleCount = behavior.smoke.count;
        double maxSpeed = behavior.smoke.maxSpeed;
        class_2400 particle = class_2398.field_17430;
        if (behavior.smoke.particle != null && class_7923.field_41180.method_10250(behavior.smoke.particle)) {
            particle = class_2398.field_17430;
        }
        for (int i = 0; i < particleCount; ++i) {
            double angle = this.field_5974.method_43058() * 2.0 * Math.PI;
            double speed = this.field_5974.method_43058() * maxSpeed;
            double dx = Math.cos(angle);
            double dz = Math.sin(angle);
            serverWorld.method_14199((class_2394)particle, (double)center.method_10263() + 0.5, (double)center.method_10264() + 0.5, (double)center.method_10260() + 0.5, 1, dx, 0.0, dz, speed);
        }
    }

    private void applySmokeEffectsToNearbyEntities(class_1937 world, ArrowBehavior behavior) {
        List entitiesInRange = world.method_8390(class_1309.class, this.method_5829().method_1014(behavior.aoeRadius), class_1309::method_5805);
        for (class_1309 entity : entitiesInRange) {
            for (ArrowBehavior.EffectEntry e : behavior.effects) {
                class_1291 effect = (class_1291)class_7923.field_41174.method_10223(e.id);
                if (effect == null) continue;
                entity.method_6092(new class_1293(effect, e.duration, e.amplifier));
            }
        }
    }

    private void igniteNearbyBlocks(class_3218 world, class_2338 hitPos, ArrowBehavior behavior) {
        Random random = new Random();
        for (class_2338 pos : class_2338.method_25996((class_2338)hitPos, (int)behavior.igniteBlocks.radiusX, (int)behavior.igniteBlocks.radiusY, (int)behavior.igniteBlocks.radiusZ)) {
            if (!world.method_8320(pos).method_26215()) continue;
            boolean canPlaceFire = false;
            for (class_2350 dir : class_2350.values()) {
                class_2338 neighbor = pos.method_10093(dir);
                class_2680 neighborState = world.method_8320(neighbor);
                if (!neighborState.method_26216((class_1922)world, neighbor) && !neighborState.method_50011()) continue;
                canPlaceFire = true;
                break;
            }
            if (!canPlaceFire || !(random.nextFloat() < behavior.igniteBlocks.chance)) continue;
            world.method_8501(pos, class_2246.field_10036.method_9564());
        }
    }
}

