/*
 * Decompiled with CFR 0.152.
 */
package net.playsi.Afkcam.modmenu;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.playsi.Afkcam.client.AFKcamResourceReloadListener;
import net.playsi.Afkcam.modmenu.NoConfigLibraryScreen;
import net.playsi.Afkcam.yacl.YACLConfigurationScreen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModMenuIntegration
implements ModMenuApi {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("AFK camera" + AFKcamResourceReloadListener.class.getName()));

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if (fabricLoader.isModLoaded("yet_another_config_lib_v3")) {
            ModContainer modContainer = (ModContainer)fabricLoader.getModContainer("yet_another_config_lib_v3").orElseThrow();
            Version version = modContainer.getMetadata().getVersion();
            try {
                Version requestsVersion = Version.parse((String)"3.7.1+1.21.6-fabric");
                if (version.compareTo((Object)requestsVersion) >= 0) {
                    return YACLConfigurationScreen::createScreen;
                }
            }
            catch (VersionParsingException e) {
                LOGGER.error("Failed to compare YACL version, tell mod author about this error: ", (Throwable)e);
            }
            return parent -> NoConfigLibraryScreen.createScreenAboutOldVersion(parent, version.getFriendlyString());
        }
        return NoConfigLibraryScreen::createScreen;
    }
}

