/*
 * Decompiled with CFR 0.152.
 */
package net.playsi.Afkcam.client.Camera;

import net.playsi.Afkcam.client.Camera.FreecamPosition;

public class CameraKeyframe {
    private double time;
    private double x;
    private double y;
    private double z;
    private double yaw;
    private double pitch;
    private InterpolationType interpolation;

    public CameraKeyframe(float time, FreecamPosition position, InterpolationType interpolation) {
        this.time = time;
        this.x = position.getX();
        this.y = position.getY();
        this.z = position.getZ();
        this.yaw = position.getYaw();
        this.pitch = position.getPitch();
        this.interpolation = interpolation;
    }

    public FreecamPosition toFreecamPosition() {
        FreecamPosition pos = new FreecamPosition();
        pos.setX(this.x);
        pos.setY(this.y);
        pos.setZ(this.z);
        pos.setRotation((float)this.yaw, (float)this.pitch);
        return pos;
    }

    public double getTime() {
        return this.time;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getPitch() {
        return this.pitch;
    }

    public InterpolationType getInterpolation() {
        return this.interpolation;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public void setInterpolation(InterpolationType interpolation) {
        this.interpolation = interpolation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CameraKeyframe)) {
            return false;
        }
        CameraKeyframe other = (CameraKeyframe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTime(), other.getTime()) != 0) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Double.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Double.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        InterpolationType this$interpolation = this.getInterpolation();
        InterpolationType other$interpolation = other.getInterpolation();
        return !(this$interpolation == null ? other$interpolation != null : !((Object)((Object)this$interpolation)).equals((Object)other$interpolation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CameraKeyframe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = Double.doubleToLongBits(this.getTime());
        result = result * 59 + (int)($time >>> 32 ^ $time);
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        long $yaw = Double.doubleToLongBits(this.getYaw());
        result = result * 59 + (int)($yaw >>> 32 ^ $yaw);
        long $pitch = Double.doubleToLongBits(this.getPitch());
        result = result * 59 + (int)($pitch >>> 32 ^ $pitch);
        InterpolationType $interpolation = this.getInterpolation();
        result = result * 59 + ($interpolation == null ? 43 : ((Object)((Object)$interpolation)).hashCode());
        return result;
    }

    public String toString() {
        return "CameraKeyframe(time=" + this.getTime() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", interpolation=" + String.valueOf((Object)this.getInterpolation()) + ")";
    }

    public CameraKeyframe(double time, double x, double y, double z, double yaw, double pitch, InterpolationType interpolation) {
        this.time = time;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.interpolation = interpolation;
    }

    public CameraKeyframe() {
    }

    public static enum InterpolationType {
        STEP,
        LINEAR,
        CATMULLROM;

    }
}

