/*
 * Decompiled with CFR 0.152.
 */
package net.playsi.Afkcam.client.Camera;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.playsi.Afkcam.client.AfkcamClient;
import net.playsi.Afkcam.client.Camera.CameraKeyframe;
import net.playsi.Afkcam.client.Camera.FreeCamManager;
import net.playsi.Afkcam.client.Camera.FreecamPosition;
import net.playsi.Afkcam.config.Config;
import net.playsi.Afkcam.utils.LogUtils;

public class CameraAnimationManager {
    private static final class_310 MC = AfkcamClient.getMC();
    private static final LogUtils LOGGER = new LogUtils(CameraAnimationManager.class);
    private static final Config CONFIG = Config.getInstance();
    private static final List<CameraKeyframe> keyframes = new ArrayList<CameraKeyframe>();
    private static boolean isPlaying = false;
    private static double currentTime = 0.0;
    private static long lastUpdateTime = 0L;
    private static double basePlayerX = 0.0;
    private static double basePlayerY = 0.0;
    private static double basePlayerZ = 0.0;
    private static double basePlayerYaw = 0.0;
    private static double lastPlayerYaw = Double.NaN;
    private static double cachedCos = 0.0;
    private static double cachedSin = 0.0;
    private static FreecamPosition lastPosition = null;
    private static final double SMOOTHING_FACTOR = 0.15;

    public static void addKeyframe(double time, double x, double y, double z, double yaw, double pitch, CameraKeyframe.InterpolationType interpolation) {
        CameraKeyframe keyframe = new CameraKeyframe(time, x, y, z, yaw, pitch, interpolation);
        int insertIndex = 0;
        for (int i = 0; i < keyframes.size(); ++i) {
            if (keyframes.get(i).getTime() > time) {
                insertIndex = i;
                break;
            }
            insertIndex = i + 1;
        }
        keyframes.add(insertIndex, keyframe);
        if (CONFIG.isDebugLogEnabled()) {
            LOGGER.infoDebug("Keyframe added at " + time + "seconds: " + String.valueOf(keyframe));
        }
    }

    public static boolean removeKeyframe(int index) {
        if (index >= 0 && index < keyframes.size()) {
            CameraKeyframe removed = keyframes.remove(index);
            if (CONFIG.isDebugLogEnabled()) {
                LOGGER.infoDebug("Keyframe deleted: " + String.valueOf(removed));
            }
            return true;
        }
        return false;
    }

    public static boolean removeKeyframeAtTime(double time) {
        for (int i = 0; i < keyframes.size(); ++i) {
            if (!(Math.abs(keyframes.get(i).getTime() - time) < 0.001)) continue;
            return CameraAnimationManager.removeKeyframe(i);
        }
        return false;
    }

    public static void clearKeyframes() {
        keyframes.clear();
        lastPosition = null;
        if (CONFIG.isDebugLogEnabled()) {
            LOGGER.infoDebug("All key frames have been cleared");
        }
    }

    public static void startPlayback() {
        if (keyframes.isEmpty()) {
            LOGGER.infoDebug("No keyframes for playback");
            return;
        }
        if (CameraAnimationManager.MC.field_1724 == null) {
            LOGGER.infoDebug("No player to play the animation");
            return;
        }
        if (!FreeCamManager.isEnabled()) {
            FreeCamManager.freecamToggle();
        }
        class_746 player = CameraAnimationManager.MC.field_1724;
        basePlayerX = player.method_23317();
        basePlayerY = player.method_23318();
        basePlayerZ = player.method_23321();
        basePlayerYaw = player.method_36454();
        isPlaying = true;
        currentTime = 0.0;
        lastUpdateTime = System.nanoTime();
        lastPosition = null;
        lastPlayerYaw = Double.NaN;
        LOGGER.infoDebug("Playback of the camera animation relative to the player's position has started:" + basePlayerX + ", " + basePlayerY + ", " + basePlayerZ + " (yaw: " + basePlayerYaw + ")");
    }

    public static void stopPlayback() {
        isPlaying = false;
        lastPosition = null;
        lastPlayerYaw = Double.NaN;
        LOGGER.infoDebug("The camera animation playback has stopped");
    }

    public static void togglePlayback() {
        if (isPlaying) {
            CameraAnimationManager.stopPlayback();
        } else {
            CameraAnimationManager.startPlayback();
        }
    }

    public static void seekToTime(double time) {
        currentTime = Math.max(0.0, time);
        lastPosition = null;
        CameraAnimationManager.updateCameraPosition();
    }

    public static void onRender(float tickDelta) {
        if (!isPlaying || keyframes.isEmpty() || FreeCamManager.getFreeCamera() == null || CameraAnimationManager.MC.field_1724 == null) {
            return;
        }
        long currentNanoTime = System.nanoTime();
        if (lastUpdateTime > 0L) {
            double realDeltaTime = (double)(currentNanoTime - lastUpdateTime) / 1.0E9;
            currentTime += realDeltaTime;
        }
        lastUpdateTime = currentNanoTime;
        double maxTime = keyframes.get(keyframes.size() - 1).getTime();
        if (currentTime > maxTime) {
            currentTime = maxTime;
            CameraAnimationManager.stopPlayback();
            return;
        }
        CameraAnimationManager.updateCameraPosition();
    }

    private static void updateCameraPosition() {
        if (keyframes.isEmpty() || CameraAnimationManager.MC.field_1724 == null) {
            return;
        }
        FreecamPosition relativePosition = CameraAnimationManager.interpolatePosition(currentTime);
        if (relativePosition == null) {
            return;
        }
        FreecamPosition absolutePosition = CONFIG.isCameraFollow() ? CameraAnimationManager.convertToAbsolutePosition(relativePosition) : CameraAnimationManager.convertToAbsolutePositionStatic(relativePosition);
        if (lastPosition != null && !absolutePosition.positionEquals(lastPosition, 0.001)) {
            absolutePosition = CameraAnimationManager.smoothPosition(lastPosition, absolutePosition, 0.15);
        }
        lastPosition = new FreecamPosition();
        lastPosition.setPosition(absolutePosition.getX(), absolutePosition.getY(), absolutePosition.getZ());
        lastPosition.setRotation(absolutePosition.getYaw(), absolutePosition.getPitch());
        FreeCamManager.getFreeCamera().applyPosition(absolutePosition);
    }

    private static FreecamPosition smoothPosition(FreecamPosition prev, FreecamPosition current, double factor) {
        FreecamPosition smoothed = new FreecamPosition();
        smoothed.setX(CameraAnimationManager.lerp(prev.getX(), current.getX(), factor));
        smoothed.setY(CameraAnimationManager.lerp(prev.getY(), current.getY(), factor));
        smoothed.setZ(CameraAnimationManager.lerp(prev.getZ(), current.getZ(), factor));
        smoothed.setRotation((float)CameraAnimationManager.lerpAngle(prev.getYaw(), current.getYaw(), factor), (float)CameraAnimationManager.lerpAngle(prev.getPitch(), current.getPitch(), factor));
        return smoothed;
    }

    private static FreecamPosition convertToAbsolutePosition(FreecamPosition relativePosition) {
        class_746 player = CameraAnimationManager.MC.field_1724;
        double currentPlayerX = player.method_23317();
        double currentPlayerY = player.method_23318();
        double currentPlayerZ = player.method_23321();
        double currentPlayerYaw = player.method_36454();
        if (Double.isNaN(lastPlayerYaw) || Math.abs(currentPlayerYaw - lastPlayerYaw) > 0.01) {
            double radianYaw = Math.toRadians(currentPlayerYaw);
            cachedCos = Math.cos(radianYaw);
            cachedSin = Math.sin(radianYaw);
            lastPlayerYaw = currentPlayerYaw;
        }
        double relX = relativePosition.getX();
        double relZ = relativePosition.getZ();
        double rotatedX = relX * cachedCos + relZ * cachedSin;
        double rotatedZ = relX * cachedSin - relZ * cachedCos;
        FreecamPosition absolutePosition = new FreecamPosition();
        absolutePosition.setX(currentPlayerX + rotatedX);
        absolutePosition.setY(currentPlayerY + relativePosition.getY());
        absolutePosition.setZ(currentPlayerZ + rotatedZ);
        absolutePosition.setRotation(player.method_36454() + relativePosition.getYaw(), relativePosition.getPitch());
        return absolutePosition;
    }

    private static FreecamPosition convertToAbsolutePositionStatic(FreecamPosition relativePosition) {
        double radianYaw = Math.toRadians(basePlayerYaw);
        double cos = Math.cos(radianYaw);
        double sin = Math.sin(radianYaw);
        double relX = relativePosition.getX();
        double relZ = relativePosition.getZ();
        double rotatedX = relX * cos + relZ * sin;
        double rotatedZ = relX * sin - relZ * cos;
        FreecamPosition absolutePosition = new FreecamPosition();
        absolutePosition.setX(basePlayerX + rotatedX);
        absolutePosition.setY(basePlayerY + relativePosition.getY());
        absolutePosition.setZ(basePlayerZ + rotatedZ);
        absolutePosition.setRotation((float)(basePlayerYaw + (double)relativePosition.getYaw()), relativePosition.getPitch());
        return absolutePosition;
    }

    private static CameraKeyframe getCurrentKeyframe() {
        for (CameraKeyframe keyframe : keyframes) {
            if (!(keyframe.getTime() >= currentTime)) continue;
            return keyframe;
        }
        return keyframes.get(keyframes.size() - 1);
    }

    private static FreecamPosition interpolatePosition(double time) {
        if (keyframes.isEmpty()) {
            return null;
        }
        if (time <= keyframes.get(0).getTime()) {
            return keyframes.get(0).toFreecamPosition();
        }
        if (time >= keyframes.get(keyframes.size() - 1).getTime()) {
            return keyframes.get(keyframes.size() - 1).toFreecamPosition();
        }
        CameraKeyframe prevKeyframe = null;
        CameraKeyframe nextKeyframe = null;
        for (int i = 0; i < keyframes.size() - 1; ++i) {
            if (!(keyframes.get(i).getTime() <= time) || !(keyframes.get(i + 1).getTime() >= time)) continue;
            prevKeyframe = keyframes.get(i);
            nextKeyframe = keyframes.get(i + 1);
            break;
        }
        if (prevKeyframe == null || nextKeyframe == null) {
            return CameraAnimationManager.getCurrentKeyframe().toFreecamPosition();
        }
        double t = (time - prevKeyframe.getTime()) / (nextKeyframe.getTime() - prevKeyframe.getTime());
        return CameraAnimationManager.interpolate(prevKeyframe, nextKeyframe, t);
    }

    private static FreecamPosition interpolate(CameraKeyframe prev, CameraKeyframe next, double t) {
        FreecamPosition result = new FreecamPosition();
        switch (prev.getInterpolation()) {
            case STEP: {
                if (t < 0.5) {
                    result.setX(prev.getX());
                    result.setY(prev.getY());
                    result.setZ(prev.getZ());
                    result.setRotation((float)prev.getYaw(), (float)prev.getPitch());
                    break;
                }
                result.setX(next.getX());
                result.setY(next.getY());
                result.setZ(next.getZ());
                result.setRotation((float)next.getYaw(), (float)next.getPitch());
                break;
            }
            case LINEAR: {
                result.setX(CameraAnimationManager.lerp(prev.getX(), next.getX(), t));
                result.setY(CameraAnimationManager.lerp(prev.getY(), next.getY(), t));
                result.setZ(CameraAnimationManager.lerp(prev.getZ(), next.getZ(), t));
                result.setRotation((float)CameraAnimationManager.lerpAngle(prev.getYaw(), next.getYaw(), t), (float)CameraAnimationManager.lerpAngle(prev.getPitch(), next.getPitch(), t));
                break;
            }
            case CATMULLROM: {
                result = CameraAnimationManager.catmullRomInterpolate(prev, next, t);
            }
        }
        return result;
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private static double lerpAngle(double a, double b, double t) {
        double diff = b - a;
        if (diff > 180.0) {
            diff -= 360.0;
        }
        if (diff < -180.0) {
            diff += 360.0;
        }
        return a + diff * t;
    }

    private static FreecamPosition catmullRomInterpolate(CameraKeyframe prev, CameraKeyframe next, double t) {
        double smoothT = t * t * (3.0 - 2.0 * t);
        FreecamPosition result = new FreecamPosition();
        result.setX(CameraAnimationManager.lerp(prev.getX(), next.getX(), smoothT));
        result.setY(CameraAnimationManager.lerp(prev.getY(), next.getY(), smoothT));
        result.setZ(CameraAnimationManager.lerp(prev.getZ(), next.getZ(), smoothT));
        result.setRotation((float)CameraAnimationManager.lerpAngle(prev.getYaw(), next.getYaw(), smoothT), (float)CameraAnimationManager.lerpAngle(prev.getPitch(), next.getPitch(), smoothT));
        return result;
    }

    public static boolean isPlaying() {
        return isPlaying;
    }

    public static double getCurrentTime() {
        return currentTime;
    }

    public static int getKeyframeCount() {
        return keyframes.size();
    }

    public static double getDuration() {
        if (keyframes.isEmpty()) {
            return 0.0;
        }
        return keyframes.get(keyframes.size() - 1).getTime();
    }

    public static double getBasePlayerX() {
        return basePlayerX;
    }

    public static double getBasePlayerY() {
        return basePlayerY;
    }

    public static double getBasePlayerZ() {
        return basePlayerZ;
    }

    public static double getBasePlayerYaw() {
        return basePlayerYaw;
    }

    public static List<CameraKeyframe> getKeyframes() {
        return keyframes;
    }
}

