/*
 * Decompiled with CFR 0.152.
 */
package org.playsi.afkcam.client.AnimationsLogic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3300;
import org.playsi.afkcam.client.AFKmode.AFKcameraManager;
import org.playsi.afkcam.client.AnimationsLogic.Parser.BbmodelPatch;
import org.playsi.afkcam.client.AnimationsLogic.Parser.RawAnimation;
import org.playsi.afkcam.client.Utils.LogUtils;

@Environment(value=EnvType.CLIENT)
public class AnimationService {
    private static final LogUtils LOGGER = new LogUtils(AFKcameraManager.class);
    private final BbmodelPatch animationLoader = new BbmodelPatch();
    private List<RawAnimation> loadedAnimations = new ArrayList<RawAnimation>();
    private Map<String, RawAnimation> animationCache = new HashMap<String, RawAnimation>();

    private AnimationService() {
    }

    public static AnimationService getInstance() {
        return Holder.INSTANCE;
    }

    public List<RawAnimation> onLoadRPs(class_3300 manager) {
        return this.animationLoader.loadAnimationsFromResources(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplyRPs(List<RawAnimation> animations) {
        AnimationService animationService = this;
        synchronized (animationService) {
            this.loadedAnimations.clear();
            this.loadedAnimations.addAll(animations);
            this.updateCache();
        }
        LOGGER.infoDebug("Applied " + animations.size() + " camera animations");
        if (animations.isEmpty()) {
            LOGGER.warnDebug("No camera animations were loaded! Check your resource files.");
        }
    }

    public List<RawAnimation> getAllAnimations() {
        return new ArrayList<RawAnimation>(this.loadedAnimations);
    }

    public RawAnimation findAnimationByName(String name) {
        return this.animationCache.get(name);
    }

    public boolean hasAnimation(String name) {
        return this.animationCache.containsKey(name);
    }

    private void updateCache() {
        this.animationCache.clear();
        for (RawAnimation animation : this.loadedAnimations) {
            this.animationCache.put(animation.getName(), animation);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class Holder {
        private static final AnimationService INSTANCE = new AnimationService();

        private Holder() {
        }
    }
}

