/*
 * Decompiled with CFR 0.152.
 */
package org.playsi.afkcam.client.Camera;

import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_243;
import net.minecraft.class_4050;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class FreecamPosition {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
    private Vector3f right = new Vector3f(1.0f, 0.0f, 0.0f);

    public FreecamPosition(class_1297 entity) {
        this.x = entity.method_23317();
        this.y = FreecamPosition.calculateCameraY(entity);
        this.z = entity.method_23321();
        this.setRotation(entity.method_36454(), entity.method_36455());
    }

    public FreecamPosition() {
    }

    public FreecamPosition(FreecamPosition other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.setRotation(other.yaw, other.pitch);
    }

    public void setRotation(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
        float yawRad = -yaw * ((float)Math.PI / 180);
        float pitchRad = pitch * ((float)Math.PI / 180);
        float cosYaw = (float)Math.cos(yawRad);
        float sinYaw = (float)Math.sin(yawRad);
        float cosPitch = (float)Math.cos(pitchRad);
        float sinPitch = (float)Math.sin(pitchRad);
        this.forward = new Vector3f(sinYaw * cosPitch, -sinPitch, cosYaw * cosPitch);
        this.up = new Vector3f(sinYaw * sinPitch, cosPitch, cosYaw * sinPitch);
        this.right = new Vector3f(cosYaw, 0.0f, -sinYaw);
    }

    public void mirrorRotation() {
        this.setRotation(this.yaw + 180.0f, -this.pitch);
    }

    public void moveForward(double distance) {
        this.move(distance, 0.0, 0.0);
    }

    public void move(double forwardOffset, double upOffset, double rightOffset) {
        this.x += (double)this.forward.x() * forwardOffset + (double)this.up.x() * upOffset + (double)this.right.x() * rightOffset;
        this.y += (double)this.forward.y() * forwardOffset + (double)this.up.y() * upOffset + (double)this.right.y() * rightOffset;
        this.z += (double)this.forward.z() * forwardOffset + (double)this.up.z() * upOffset + (double)this.right.z() * rightOffset;
    }

    public class_1923 getChunkPos() {
        return new class_1923((int)(this.x / 16.0), (int)(this.z / 16.0));
    }

    public Vector3f getPositionVec3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public class_243 getPositionVec3d() {
        return new class_243(this.x, this.y, this.z);
    }

    public FreecamPosition copy() {
        return new FreecamPosition(this);
    }

    public void setPosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean positionEquals(FreecamPosition other, double epsilon) {
        if (other == null) {
            return false;
        }
        return Math.abs(this.x - other.x) < epsilon && Math.abs(this.y - other.y) < epsilon && Math.abs(this.z - other.z) < epsilon && (double)Math.abs(this.yaw - other.yaw) < epsilon && (double)Math.abs(this.pitch - other.pitch) < epsilon;
    }

    public String toString() {
        return String.format("FreecamPosition[x=%.2f, y=%.2f, z=%.2f, yaw=%.2f, pitch=%.2f]", this.x, this.y, this.z, Float.valueOf(this.yaw), Float.valueOf(this.pitch));
    }

    private static double calculateCameraY(class_1297 entity) {
        if (entity.method_18376() == class_4050.field_18079) {
            return entity.method_23318();
        }
        return entity.method_23318() - (double)entity.method_18381(class_4050.field_18079) + (double)entity.method_18381(entity.method_18376());
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public void setX(double x) {
        this.x = x;
    }

    @Generated
    public void setY(double y) {
        this.y = y;
    }

    @Generated
    public void setZ(double z) {
        this.z = z;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    @Generated
    public void setPitch(float pitch) {
        this.pitch = pitch;
    }
}

