/*
 * Decompiled with CFR 0.152.
 */
package org.playsi.afkcam.client.Utils;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.playsi.afkcam.client.AfkcamClient;
import org.playsi.afkcam.client.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class LogUtils {
    private final Logger logger = LoggerFactory.getLogger((String)"Afk camera");
    private final String className;
    private static final Config config = AfkcamClient.getConfig();

    public LogUtils(Class<?> clazz) {
        this.className = clazz.getSimpleName();
    }

    public void info(String message) {
        if (config.isModEnabled()) {
            this.logger.info("[{}] {}", (Object)this.className, (Object)message);
        }
    }

    public void warn(String message) {
        if (config.isModEnabled()) {
            this.logger.warn("[{}] {}", (Object)this.className, (Object)message);
        }
    }

    public void error(String message) {
        if (config.isModEnabled()) {
            this.logger.error("[{}] {}", (Object)this.className, (Object)message);
        }
    }

    public void infoDebug(String message) {
        if (config.isModEnabled() && config.isDebugLogEnabled()) {
            this.logger.info("[{}] [DEBUG] {}", (Object)this.className, (Object)message);
        }
    }

    public void warnDebug(String message) {
        if (config.isModEnabled() && config.isDebugLogEnabled()) {
            this.logger.warn("[{}] [DEBUG] {}", (Object)this.className, (Object)message);
        }
    }

    public void errorDebug(String message) {
        if (config.isModEnabled() && config.isDebugLogEnabled()) {
            this.logger.error("[{}] [DEBUG] {}", (Object)this.className, (Object)message);
        }
    }
}

