/*
 * Decompiled with CFR 0.152.
 */
package net.playsi.Afkcam.client.Animations;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;

public class RawAnimation {
    private final String name;
    private final List<Keyframe> positionKeyframes = new ArrayList<Keyframe>();
    private final List<Keyframe> rotationKeyframes = new ArrayList<Keyframe>();

    public RawAnimation(String name) {
        this.name = name;
    }

    public void addPositionKeyframe(float time, float x, float y, float z, String interp) {
        this.positionKeyframes.add(new Keyframe(time, new float[]{x, y, z}, interp));
    }

    public void addRotationKeyframe(float time, float x, float y, float z, String interp) {
        this.rotationKeyframes.add(new Keyframe(time, new float[]{x, y, z}, interp));
    }

    public static float parseFloatValue(JsonElement element) {
        if (element.isJsonPrimitive()) {
            try {
                if (element.getAsJsonPrimitive().isString()) {
                    return Float.parseFloat(element.getAsString());
                }
                return element.getAsFloat();
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public String getName() {
        return this.name;
    }

    public List<Keyframe> getPositionKeyframes() {
        return this.positionKeyframes;
    }

    public List<Keyframe> getRotationKeyframes() {
        return this.rotationKeyframes;
    }

    public static class Keyframe {
        private final float time;
        private final float[] values;
        private final String interpolation;

        public Keyframe(float time, float[] values, String interpolation) {
            this.time = time;
            this.values = values;
            this.interpolation = interpolation;
        }

        public float getTime() {
            return this.time;
        }

        public float[] getValues() {
            return this.values;
        }

        public String getInterpolation() {
            return this.interpolation;
        }
    }
}

