/*
 * Decompiled with CFR 0.152.
 */
package net.playsi.Afkcam.utils;

import net.playsi.Afkcam.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private final Logger logger = LoggerFactory.getLogger((String)"AFK camera");
    private final String className;
    private static final Config CONFIG = Config.getInstance();

    public LogUtils(Class<?> clazz) {
        this.className = clazz.getSimpleName();
    }

    public void info(String message) {
        if (CONFIG.isModEnabled()) {
            this.logger.info("[{}] {}", (Object)this.className, (Object)message);
        }
    }

    public void warn(String message) {
        if (CONFIG.isModEnabled()) {
            this.logger.warn("[{}] {}", (Object)this.className, (Object)message);
        }
    }

    public void error(String message) {
        if (CONFIG.isModEnabled()) {
            this.logger.error("[{}] {}", (Object)this.className, (Object)message);
        }
    }

    public void infoDebug(String message) {
        if (CONFIG.isModEnabled() && CONFIG.isDebugLogEnabled()) {
            this.logger.info("[{}] [DEBUG] {}", (Object)this.className, (Object)message);
        }
    }

    public void warnDebug(String message) {
        if (CONFIG.isModEnabled() && CONFIG.isDebugLogEnabled()) {
            this.logger.warn("[{}] [DEBUG] {}", (Object)this.className, (Object)message);
        }
    }

    public void errorDebug(String message) {
        if (CONFIG.isModEnabled() && CONFIG.isDebugLogEnabled()) {
            this.logger.error("[{}] [DEBUG] {}", (Object)this.className, (Object)message);
        }
    }
}

