/*
 * Decompiled with CFR 0.152.
 */
package org.playsi.afkcam.client.AFKmode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.playsi.afkcam.client.AFKmode.AFKConditions;
import org.playsi.afkcam.client.AFKmode.HudManager;
import org.playsi.afkcam.client.AfkcamClient;
import org.playsi.afkcam.client.AnimationsLogic.AnimationService;
import org.playsi.afkcam.client.AnimationsLogic.Parser.RawAnimation;
import org.playsi.afkcam.client.Camera.CameraAnimationManager;
import org.playsi.afkcam.client.Camera.CameraKeyframe;
import org.playsi.afkcam.client.Camera.FreeCamManager;
import org.playsi.afkcam.client.Utils.LogUtils;
import org.playsi.afkcam.client.config.Config;

@Environment(value=EnvType.CLIENT)
public class AFKcameraManager {
    private static final class_310 MC = AfkcamClient.getMC();
    private static final Config CONFIG = AfkcamClient.getConfig();
    private static final LogUtils LOGGER = new LogUtils(AFKcameraManager.class);
    private static final float SCALE_FACTOR = 0.0625f;
    private static boolean isAfkModeActive = false;
    private static long lastActivityTime = System.currentTimeMillis();
    private static List<RawAnimation> availableAnimations = new ArrayList<RawAnimation>();
    private static int currentAnimationIndex = 0;
    private static Random animationRandom = new Random();

    public static void tick() {
        if (CONFIG.isModEnabled() || !AFKcameraManager.isInWorld()) {
            if (!isAfkModeActive && AFKcameraManager.shouldActivateAfkMode()) {
                AFKcameraManager.activateAfkMode();
            } else if (isAfkModeActive && !AFKConditions.hasAFKConditions()) {
                AFKcameraManager.deactivateAfkMode();
            }
            if (isAfkModeActive) {
                AFKcameraManager.tickAfkMode();
            }
        }
    }

    public static void onRender(float tickDelta) {
        if (isAfkModeActive) {
            CameraAnimationManager.onRender(tickDelta);
        }
    }

    private static boolean shouldActivateAfkMode() {
        long timeSinceActivity;
        if (!AFKcameraManager.isInWorld()) {
            return false;
        }
        if (isAfkModeActive) {
            return false;
        }
        if (!AFKConditions.hasAFKConditions()) {
            lastActivityTime = System.currentTimeMillis();
        }
        return (timeSinceActivity = System.currentTimeMillis() - lastActivityTime) >= (long)CONFIG.getActivationAfter() * 1000L;
    }

    private static boolean isInWorld() {
        return AFKcameraManager.MC.field_1687 != null && AFKcameraManager.MC.field_1724 != null && !MC.method_1493();
    }

    private static void activateAfkMode() {
        LOGGER.infoDebug("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f AFK \u0440\u0435\u0436\u0438\u043c\u0430 \u043a\u0430\u043c\u0435\u0440\u044b");
        AFKcameraManager.loadAvailableAnimations();
        if (availableAnimations.isEmpty()) {
            LOGGER.warn("\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u0439 \u0434\u043b\u044f AFK \u0440\u0435\u0436\u0438\u043c\u0430");
            return;
        }
        isAfkModeActive = true;
        if (!FreeCamManager.isEnabled()) {
            FreeCamManager.freecamToggle();
        }
        HudManager.hidePlayerHud();
        AFKcameraManager.startNextAnimation();
    }

    private static void deactivateAfkMode() {
        LOGGER.infoDebug("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f AFK \u0440\u0435\u0436\u0438\u043c\u0430 \u043a\u0430\u043c\u0435\u0440\u044b");
        isAfkModeActive = false;
        CameraAnimationManager.stopPlayback();
        HudManager.restorePlayerHud();
        if (FreeCamManager.isEnabled()) {
            FreeCamManager.freecamToggle();
        }
        lastActivityTime = System.currentTimeMillis();
    }

    private static void tickAfkMode() {
        if (!CameraAnimationManager.isPlaying()) {
            AFKcameraManager.startNextAnimation();
        }
    }

    private static void loadAvailableAnimations() {
        availableAnimations.clear();
        currentAnimationIndex = 0;
        availableAnimations = new ArrayList<RawAnimation>(AnimationService.getInstance().getAllAnimations());
        LOGGER.infoDebug("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + availableAnimations.size() + " \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u0439");
        Collections.shuffle(availableAnimations, animationRandom);
    }

    private static void startNextAnimation() {
        if (availableAnimations.isEmpty()) {
            LOGGER.warnDebug("No animations available for playback");
            AFKcameraManager.deactivateAfkMode();
            return;
        }
        RawAnimation nextAnimation = availableAnimations.get(currentAnimationIndex);
        if ((currentAnimationIndex = (currentAnimationIndex + 1) % availableAnimations.size()) == 0) {
            Collections.shuffle(availableAnimations, animationRandom);
        }
        LOGGER.infoDebug("Start animation: " + nextAnimation.getName());
        AFKcameraManager.convertAndLoadAnimation(nextAnimation);
        CameraAnimationManager.startPlayback();
    }

    private static void convertAndLoadAnimation(RawAnimation animation) {
        float[] rotation;
        float[] position;
        float time;
        CameraAnimationManager.clearKeyframes();
        List<RawAnimation.Keyframe> posFrames = animation.getPositionKeyframes();
        List<RawAnimation.Keyframe> rotFrames = animation.getRotationKeyframes();
        HashMap<Float, RawAnimation.Keyframe> rotationMap = new HashMap<Float, RawAnimation.Keyframe>();
        for (RawAnimation.Keyframe rotFrame : rotFrames) {
            rotationMap.put(Float.valueOf(rotFrame.getTime()), rotFrame);
        }
        for (RawAnimation.Keyframe posFrame : posFrames) {
            time = posFrame.getTime();
            position = posFrame.getValues();
            rotation = AFKcameraManager.findOrInterpolateRotation(rotFrames, time);
            CameraKeyframe.InterpolationType interpType = CameraKeyframe.InterpolationType.LINEAR;
            CameraAnimationManager.addKeyframe(time, position[0] * 0.0625f, position[1] * 0.0625f, position[2] * 0.0625f, rotation[1], rotation[0], interpType);
        }
        for (RawAnimation.Keyframe rotFrame : rotFrames) {
            time = rotFrame.getTime();
            if (!posFrames.stream().noneMatch(pf -> Math.abs(pf.getTime() - time) < 0.001f)) continue;
            position = AFKcameraManager.findOrInterpolatePosition(posFrames, time);
            rotation = rotFrame.getValues();
            CameraAnimationManager.addKeyframe(time, position[0] * 0.0625f, position[1] * 0.0625f, position[2] * 0.0625f, rotation[1], rotation[0], CameraKeyframe.InterpolationType.LINEAR);
        }
    }

    private static float[] findOrInterpolateRotation(List<RawAnimation.Keyframe> rotFrames, float time) {
        if (rotFrames.isEmpty()) {
            return new float[]{0.0f, 0.0f};
        }
        for (RawAnimation.Keyframe frame : rotFrames) {
            if (!(Math.abs(frame.getTime() - time) < 0.001f)) continue;
            return frame.getValues();
        }
        RawAnimation.Keyframe prevFrame = null;
        RawAnimation.Keyframe nextFrame = null;
        for (RawAnimation.Keyframe frame : rotFrames) {
            if (frame.getTime() <= time) {
                prevFrame = frame;
                continue;
            }
            if (nextFrame != null) continue;
            nextFrame = frame;
            break;
        }
        if (prevFrame == null) {
            return rotFrames.get(0).getValues();
        }
        if (nextFrame == null) {
            return rotFrames.get(rotFrames.size() - 1).getValues();
        }
        float t = (time - prevFrame.getTime()) / (nextFrame.getTime() - prevFrame.getTime());
        float[] prevRot = prevFrame.getValues();
        float[] nextRot = nextFrame.getValues();
        return new float[]{prevRot[0] + (nextRot[0] - prevRot[0]) * t, prevRot[1] + (nextRot[1] - prevRot[1]) * t};
    }

    private static float[] findOrInterpolatePosition(List<RawAnimation.Keyframe> posFrames, float time) {
        Object values2;
        if (posFrames.isEmpty()) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        for (RawAnimation.Keyframe frame : posFrames) {
            if (!(Math.abs(frame.getTime() - time) < 0.001f)) continue;
            float[] values2 = frame.getValues();
            return new float[]{values2[0] * 0.0625f, values2[1] * 0.0625f, values2[2] * 0.0625f};
        }
        RawAnimation.Keyframe prevFrame = null;
        RawAnimation.Keyframe nextFrame = null;
        for (RawAnimation.Keyframe frame : posFrames) {
            if (frame.getTime() <= time) {
                prevFrame = frame;
                continue;
            }
            if (nextFrame != null) continue;
            nextFrame = frame;
            break;
        }
        if (prevFrame == null) {
            values2 = posFrames.get(0).getValues();
            return new float[]{(float)(values2[0] * 0.0625f), (float)(values2[1] * 0.0625f), (float)(values2[2] * 0.0625f)};
        }
        if (nextFrame == null) {
            values2 = posFrames.get(posFrames.size() - 1).getValues();
            return new float[]{(float)(values2[0] * 0.0625f), (float)(values2[1] * 0.0625f), (float)(values2[2] * 0.0625f)};
        }
        float t = (time - prevFrame.getTime()) / (nextFrame.getTime() - prevFrame.getTime());
        float[] prevPos = prevFrame.getValues();
        float[] nextPos = nextFrame.getValues();
        return new float[]{(prevPos[0] + (nextPos[0] - prevPos[0]) * t) * 0.0625f, (prevPos[1] + (nextPos[1] - prevPos[1]) * t) * 0.0625f, (prevPos[2] + (nextPos[2] - prevPos[2]) * t) * 0.0625f};
    }

    public static void onDisconnect() {
        AFKcameraManager.deactivateAfkMode();
    }

    @Generated
    public static boolean isAfkModeActive() {
        return isAfkModeActive;
    }
}

