/*
 * Decompiled with CFR 0.152.
 */
package org.playsi.afkcam.client.AnimationsLogic.Parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.playsi.afkcam.client.AFKmode.AFKcameraManager;
import org.playsi.afkcam.client.AfkcamClient;
import org.playsi.afkcam.client.AnimationsLogic.Parser.BbModelAnim;
import org.playsi.afkcam.client.AnimationsLogic.Parser.RawAnimation;
import org.playsi.afkcam.client.Utils.LogUtils;

@Environment(value=EnvType.CLIENT)
public class BbmodelPatch {
    private static final LogUtils LOGGER = new LogUtils(AFKcameraManager.class);
    private static final String CAMERA_RESOURCE_PATH = "cinematic_camera";
    private static final String BBMODEL_EXTENSION = ".bbmodel";

    public List<RawAnimation> loadAnimationsFromResources(class_3300 manager) {
        ArrayList<RawAnimation> animToLoad = new ArrayList<RawAnimation>();
        if (!AfkcamClient.getConfig().isModEnabled()) {
            return animToLoad;
        }
        try {
            LOGGER.infoDebug("Looking for .bbmodel files in cinematic_camera:");
            Map bbmodelResources = manager.method_14488(CAMERA_RESOURCE_PATH, id -> id.method_12832().endsWith(BBMODEL_EXTENSION));
            LOGGER.info("Found " + bbmodelResources.size() + " .bbmodel files");
            if (bbmodelResources.isEmpty()) {
                LOGGER.errorDebug("Make sure .bbmodel files are in the correct location:");
                LOGGER.errorDebug("   * assets/<namespace>/cinematic_camera/*.bbmodel");
            }
            bbmodelResources.forEach((id, resource) -> {
                if (this.shouldSkipAfkcamResource((class_2960)id)) {
                    LOGGER.infoDebug("Skipping afkcam resource: " + String.valueOf(id) + " (default animations disabled)");
                    return;
                }
                try {
                    List<RawAnimation> animations = this.parseAnimFromBb((class_2960)id, (class_3298)resource);
                    animToLoad.addAll(animations);
                }
                catch (Exception e) {
                    LOGGER.errorDebug("Failed to load camera file: " + String.valueOf(id) + " - " + e.getMessage());
                }
            });
            LOGGER.info("Total camera animations loaded: " + animToLoad.size());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return animToLoad;
    }

    private boolean shouldSkipAfkcamResource(class_2960 resourceId) {
        return "afkcam".equals(resourceId.method_12836()) && !AfkcamClient.getConfig().isLoadDefaultAnimation();
    }

    private List<RawAnimation> parseAnimFromBb(class_2960 id, class_3298 resource) throws IOException {
        LOGGER.infoDebug("Processing .bbmodel file: " + String.valueOf(id));
        try (InputStream inputStream = resource.method_14482();){
            List<RawAnimation> list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                List<RawAnimation> animations = BbModelAnim.parseAnimationsFromJson(reader);
                if (animations.isEmpty()) {
                    LOGGER.errorDebug("No camera animations extracted from file: " + String.valueOf(id));
                } else {
                    LOGGER.infoDebug("Successfully found " + animations.size() + " camera animations in: " + String.valueOf(id));
                }
                list = animations;
            }
            return list;
        }
    }
}

