/*
 * Decompiled with CFR 0.152.
 */
package org.playsi.afkcam.client.AnimationsLogic.Parser;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class RawAnimation {
    private final String name;
    private final List<Keyframe> positionKeyframes = new ArrayList<Keyframe>();
    private final List<Keyframe> rotationKeyframes = new ArrayList<Keyframe>();

    public RawAnimation(String name) {
        this.name = name;
    }

    public void addPositionKeyframe(float time, float x, float y, float z, String interp) {
        this.positionKeyframes.add(new Keyframe(time, new float[]{x, y, z}, interp));
    }

    public void addRotationKeyframe(float time, float x, float y, float z, String interp) {
        this.rotationKeyframes.add(new Keyframe(time, new float[]{x, y, z}, interp));
    }

    public static float parseFloatValue(JsonElement element) {
        if (element.isJsonPrimitive()) {
            try {
                if (element.getAsJsonPrimitive().isString()) {
                    return Float.parseFloat(element.getAsString());
                }
                return element.getAsFloat();
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<Keyframe> getPositionKeyframes() {
        return this.positionKeyframes;
    }

    @Generated
    public List<Keyframe> getRotationKeyframes() {
        return this.rotationKeyframes;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Keyframe {
        private final float time;
        private final float[] values;
        private final String interpolation;

        public Keyframe(float time, float[] values, String interpolation) {
            this.time = time;
            this.values = values;
            this.interpolation = interpolation;
        }

        @Generated
        public float getTime() {
            return this.time;
        }

        @Generated
        public float[] getValues() {
            return this.values;
        }

        @Generated
        public String getInterpolation() {
            return this.interpolation;
        }
    }
}

