/*
 * Decompiled with CFR 0.152.
 */
package org.playsi.afkcam.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import org.playsi.afkcam.client.AnimationsLogic.AnimationService;
import org.playsi.afkcam.client.AnimationsLogic.Parser.RawAnimation;

@Environment(value=EnvType.CLIENT)
public class AFKcamCommands {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cinematicanimations").then(ClientCommandManager.argument((String)"animation", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            List<RawAnimation> animations = AnimationService.getInstance().getAllAnimations();
            for (RawAnimation anim : animations) {
                builder.suggest(anim.getName());
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"animation");
            List<RawAnimation> animations = AnimationService.getInstance().getAllAnimations();
            for (RawAnimation anim : animations) {
                if (!anim.getName().equals(name)) continue;
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Animation: " + anim.getName())));
                for (RawAnimation.Keyframe kf : anim.getPositionKeyframes()) {
                    ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Time: %.2f, Position: [%.2f, %.2f, %.2f], Interpolation: %s", Float.valueOf(kf.getTime()), Float.valueOf(kf.getValues()[0]), Float.valueOf(kf.getValues()[1]), Float.valueOf(kf.getValues()[2]), kf.getInterpolation())));
                }
                for (RawAnimation.Keyframe kf : anim.getRotationKeyframes()) {
                    ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Time: %.2f, Rotation: [%.2f, %.2f, %.2f], Interpolation: %s", Float.valueOf(kf.getTime()), Float.valueOf(kf.getValues()[0]), Float.valueOf(kf.getValues()[1]), Float.valueOf(kf.getValues()[2]), kf.getInterpolation())));
                }
                return 1;
            }
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Animation not found: " + name)));
            return 0;
        }))).executes(ctx -> {
            List<RawAnimation> animations = AnimationService.getInstance().getAllAnimations();
            if (animations.isEmpty()) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"No animations found."));
            } else {
                for (RawAnimation anim : animations) {
                    ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Animation: " + anim.getName())));
                    for (RawAnimation.Keyframe kf : anim.getPositionKeyframes()) {
                        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Time: %.2f, Position: [%.2f, %.2f, %.2f], Interpolation: %s", Float.valueOf(kf.getTime()), Float.valueOf(kf.getValues()[0]), Float.valueOf(kf.getValues()[1]), Float.valueOf(kf.getValues()[2]), kf.getInterpolation())));
                    }
                    for (RawAnimation.Keyframe kf : anim.getRotationKeyframes()) {
                        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Time: %.2f, Rotation: [%.2f, %.2f, %.2f], Interpolation: %s", Float.valueOf(kf.getTime()), Float.valueOf(kf.getValues()[0]), Float.valueOf(kf.getValues()[1]), Float.valueOf(kf.getValues()[2]), kf.getInterpolation())));
                    }
                }
            }
            return 1;
        })));
    }
}

