/*
 * Decompiled with CFR 0.152.
 */
package org.playsi.afkcam.client.AnimationsLogic.Parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.playsi.afkcam.client.AnimationsLogic.Parser.RawAnimation;
import org.playsi.afkcam.client.Utils.LogUtils;

@Environment(value=EnvType.CLIENT)
public class BbModelAnim {
    private static final LogUtils LOGGER = new LogUtils(BbModelAnim.class);
    private static final Set<String> ALLOWED_VALUES = Set.of("step", "linear", "catmullrom");

    public static List<RawAnimation> parseAnimationsFromJson(BufferedReader reader) {
        ArrayList<RawAnimation> animations = new ArrayList<RawAnimation>();
        JsonElement root = JsonParser.parseReader((Reader)reader);
        if (!root.isJsonObject()) {
            LOGGER.errorDebug("Root element is not a JSON object");
            return animations;
        }
        JsonObject obj = root.getAsJsonObject();
        if (!obj.has("animations")) {
            LOGGER.errorDebug("JSON object doesn't have 'animations' property");
            return animations;
        }
        JsonElement animElement = obj.get("animations");
        if (!animElement.isJsonArray()) {
            LOGGER.errorDebug("'animations' is not a JSON array");
            return animations;
        }
        JsonArray animArray = animElement.getAsJsonArray();
        LOGGER.info("Found " + animArray.size() + " animation entries to process");
        if (animArray.isEmpty()) {
            LOGGER.warnDebug("Animations array is empty!");
            return animations;
        }
        if (!animArray.isEmpty() && animArray.get(0).isJsonObject()) {
            JsonElement animatorsElem;
            JsonObject firstAnim = animArray.get(0).getAsJsonObject();
            LOGGER.infoDebug("First animation properties: " + String.valueOf(firstAnim.keySet()));
            if (firstAnim.has("animators") && (animatorsElem = firstAnim.get("animators")).isJsonObject()) {
                JsonObject animatorsObj = animatorsElem.getAsJsonObject();
                LOGGER.infoDebug("Animators has " + animatorsObj.keySet().size() + " keys");
                for (String key : animatorsObj.keySet()) {
                    JsonObject animatorObj;
                    LOGGER.infoDebug(" - Animator key: " + key);
                    JsonElement animator = animatorsObj.get(key);
                    if (!animator.isJsonObject() || !(animatorObj = animator.getAsJsonObject()).has("name")) continue;
                    LOGGER.infoDebug("   * Name: " + animatorObj.get("name").getAsString());
                }
            }
        }
        BbModelAnim.parseAnimationsFromArray(animArray, animations);
        return animations;
    }

    private static void parseAnimationsFromArray(JsonArray animArray, List<RawAnimation> animations) {
        for (JsonElement animEl : animArray) {
            String animationName;
            if (!animEl.isJsonObject()) continue;
            JsonObject animObj = animEl.getAsJsonObject();
            String string = animationName = animObj.has("name") ? animObj.get("name").getAsString() : "unnamed";
            if (!animObj.has("animators")) {
                LOGGER.errorDebug("Animation missing 'animators' property: " + animationName);
                continue;
            }
            JsonElement animatorsElem = animObj.get("animators");
            if (!animatorsElem.isJsonObject()) {
                LOGGER.errorDebug("'animators' is not a JSON object in animation: " + animationName);
                continue;
            }
            JsonObject animatorsObj = animatorsElem.getAsJsonObject();
            boolean foundCameraAnimator = false;
            for (String key : animatorsObj.keySet()) {
                JsonElement animatorElem = animatorsObj.get(key);
                if (!animatorElem.isJsonObject()) continue;
                JsonObject animatorObj = animatorElem.getAsJsonObject();
                if (!animatorObj.has("name")) {
                    LOGGER.errorDebug("Animator missing 'name' property in animation: " + animationName);
                    continue;
                }
                String boneName = animatorObj.get("name").getAsString();
                if (!"camera".equalsIgnoreCase(boneName)) {
                    LOGGER.infoDebug("Skipping non-camera animator: " + boneName);
                    continue;
                }
                LOGGER.infoDebug("Found camera animator in animation: " + animationName);
                foundCameraAnimator = true;
                RawAnimation camAnim = new RawAnimation(animationName);
                if (!animatorObj.has("keyframes")) {
                    LOGGER.warnDebug("Camera animator missing keyframes in animation: " + animationName);
                    continue;
                }
                JsonElement keysElement = animatorObj.get("keyframes");
                if (!keysElement.isJsonArray()) {
                    LOGGER.warnDebug("Keyframes is not a JSON array in animation: " + animationName);
                    continue;
                }
                JsonArray keys = keysElement.getAsJsonArray();
                BbModelAnim.parseKeyframes(keys, camAnim, animationName);
                if (camAnim.getPositionKeyframes().isEmpty() && camAnim.getRotationKeyframes().isEmpty()) {
                    LOGGER.warnDebug("Camera animation has no usable keyframes: " + animationName);
                    continue;
                }
                LOGGER.infoDebug("Added camera animation: " + animationName + " (pos keys: " + camAnim.getPositionKeyframes().size() + ", rot keys: " + camAnim.getRotationKeyframes().size() + ")");
                animations.add(camAnim);
            }
            if (foundCameraAnimator) continue;
            LOGGER.errorDebug("No camera animator found in animation: " + animationName);
        }
    }

    private static void parseKeyframes(JsonArray keys, RawAnimation camAnim, String animationName) {
        for (JsonElement keyEl : keys) {
            float z;
            float y;
            float x;
            JsonObject dataPoint;
            JsonElement dataPointsElem;
            if (!keyEl.isJsonObject()) continue;
            JsonObject keyObj = keyEl.getAsJsonObject();
            float time = keyObj.has("time") ? keyObj.get("time").getAsFloat() : 0.0f;
            String channel = keyObj.has("channel") ? keyObj.get("channel").getAsString() : "";
            String interp = BbModelAnim.parseInterpolation(keyObj);
            if ("position".equals(channel) && keyObj.has("data_points") && (dataPointsElem = keyObj.get("data_points")).isJsonArray() && !dataPointsElem.getAsJsonArray().isEmpty() && (dataPoint = dataPointsElem.getAsJsonArray().get(0).getAsJsonObject()).has("x") && dataPoint.has("y") && dataPoint.has("z")) {
                x = RawAnimation.parseFloatValue(dataPoint.get("x"));
                y = RawAnimation.parseFloatValue(dataPoint.get("y"));
                z = RawAnimation.parseFloatValue(dataPoint.get("z"));
                camAnim.addPositionKeyframe(time, x, y, z, interp);
                LOGGER.infoDebug("Added position keyframe at t=" + time + " pos=(" + x + "," + y + "," + z + ")" + interp);
            }
            if (!"rotation".equals(channel) || !keyObj.has("data_points") || !(dataPointsElem = keyObj.get("data_points")).isJsonArray() || dataPointsElem.getAsJsonArray().isEmpty() || !(dataPoint = dataPointsElem.getAsJsonArray().get(0).getAsJsonObject()).has("x") || !dataPoint.has("y") || !dataPoint.has("z")) continue;
            x = RawAnimation.parseFloatValue(dataPoint.get("x"));
            y = RawAnimation.parseFloatValue(dataPoint.get("y"));
            z = RawAnimation.parseFloatValue(dataPoint.get("z"));
            camAnim.addRotationKeyframe(time, x, y, z, interp);
            LOGGER.infoDebug("Added rotation keyframe at t=" + time + " rot=(" + x + "," + y + "," + z + ")" + interp);
        }
    }

    private static String parseInterpolation(JsonObject keyObj) {
        String defaultInterpolation = "catmullrom";
        String value = null;
        if (keyObj.has("interpolation") && ALLOWED_VALUES.contains(value = keyObj.get("interpolation").getAsString())) {
            return value;
        }
        LOGGER.warnDebug("Invalid interpolation value: " + value + ". Default value used: " + defaultInterpolation);
        return defaultInterpolation;
    }
}

