/*
 * Decompiled with CFR 0.152.
 */
package org.playsi.afkcam.client.Camera;

import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_5498;
import org.playsi.afkcam.client.AfkcamClient;
import org.playsi.afkcam.client.Camera.FreeCamera;
import org.playsi.afkcam.client.Utils.LogUtils;

@Environment(value=EnvType.CLIENT)
public class FreeCamManager {
    private static final double FIRST_PERSON_OFFSET = 0.4;
    private static final double THIRD_PERSON_OFFSET = -4.0;
    private static final double COLLISION_CHECK_INCREMENT = 0.1;
    private static final int FREECAM_ENTITY_ID = -420;
    private static final class_310 MC = AfkcamClient.getMC();
    private static final LogUtils LOGGER = new LogUtils(FreeCamManager.class);
    private static FreeCamera freeCamera;
    private static boolean freecamEnabled;
    private static boolean disableNextTick;
    private static class_5498 rememberedPerspective;

    public static void toggleFreecam() {
        if (!FreeCamManager.canToggleFreecam()) {
            return;
        }
        FreeCamManager.freecamToggle();
    }

    public static void enableFreecam() {
        if (!freecamEnabled && FreeCamManager.canToggleFreecam()) {
            FreeCamManager.freecamToggle();
        }
    }

    public static void disableFreecam() {
        if (freecamEnabled) {
            FreeCamManager.freecamToggle();
        }
    }

    private static boolean canToggleFreecam() {
        return FreeCamManager.MC.field_1724 != null && FreeCamManager.MC.field_1687 != null && !MC.method_1493();
    }

    public static void teleportFreecam(double x, double y, double z) {
        if (freeCamera != null) {
            freeCamera.applyPosition(x, y, z, freeCamera.method_36454(), freeCamera.method_36455());
        }
    }

    public static void teleportFreecam(double x, double y, double z, float yaw, float pitch) {
        if (freeCamera != null) {
            freeCamera.applyPosition(x, y, z, yaw, pitch);
        }
    }

    public static void preTick(class_310 mc) {
        if (disableNextTick && FreeCamManager.isEnabled()) {
            FreeCamManager.freecamToggle();
        }
        disableNextTick = false;
        if (FreeCamManager.isEnabled()) {
            mc.field_1773.method_35768(false);
        }
    }

    public static void onDisconnect() {
        if (FreeCamManager.isEnabled()) {
            freecamEnabled = true;
            FreeCamManager.freecamToggle();
        }
    }

    public static void freecamToggle() {
        if (freecamEnabled) {
            FreeCamManager.onDisableFreecam();
        } else {
            FreeCamManager.onEnableFreecam();
        }
        freecamEnabled = !freecamEnabled;
    }

    public static void freecamToggle(boolean active) {
        if (active && !freecamEnabled) {
            FreeCamManager.onEnableFreecam();
            freecamEnabled = true;
        } else if (!active && freecamEnabled) {
            FreeCamManager.onDisableFreecam();
            freecamEnabled = false;
        }
    }

    private static void onEnableFreecam() {
        if (FreeCamManager.MC.field_1724 == null || FreeCamManager.MC.field_1687 == null) {
            LOGGER.infoDebug("Cannot enable freecam: player or world is null");
            return;
        }
        FreeCamManager.onEnable();
        freeCamera = new FreeCamera(-420);
        FreeCamManager.moveToPlayer();
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        LOGGER.infoDebug("Freecam enabled");
    }

    private static void onDisableFreecam() {
        LOGGER.infoDebug("Disabling freecam");
        if (FreeCamManager.MC.field_1724 != null) {
            MC.method_1504((class_1297)FreeCamManager.MC.field_1724);
        }
        if (freeCamera != null) {
            freeCamera.despawn();
            freeCamera = null;
        }
        FreeCamManager.onDisable();
        LOGGER.infoDebug("Freecam disabled");
    }

    private static void onEnable() {
        FreeCamManager.MC.field_1730 = false;
        FreeCamManager.MC.field_1773.method_35768(false);
        rememberedPerspective = FreeCamManager.MC.field_1690.method_31044();
        FreeCamManager.MC.field_1690.method_31043(class_5498.field_26664);
    }

    private static void onDisable() {
        FreeCamManager.MC.field_1730 = true;
        FreeCamManager.MC.field_1773.method_35768(true);
        if (rememberedPerspective != null) {
            FreeCamManager.MC.field_1690.method_31043(rememberedPerspective);
        }
    }

    public static void moveToPlayer() {
        if (freeCamera == null || FreeCamManager.MC.field_1724 == null) {
            return;
        }
        freeCamera.copyPosition((class_1297)FreeCamManager.MC.field_1724);
        freeCamera.applyPerspective(class_5498.field_26664, true);
    }

    public static void disableNextTick() {
        disableNextTick = true;
    }

    public static boolean isEnabled() {
        return freecamEnabled;
    }

    @Generated
    public static FreeCamera getFreeCamera() {
        return freeCamera;
    }

    static {
        freecamEnabled = false;
        disableNextTick = false;
        rememberedPerspective = class_5498.field_26664;
    }
}

