/*
 * Decompiled with CFR 0.152.
 */
package net.playsi.Afkcam.config;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.playsi.Afkcam.utils.CodecUtils;
import net.playsi.Afkcam.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("modEnabled", true, Codec.BOOL, Config::isModEnabled), CodecUtils.option("debugLogEnabled", false, Codec.BOOL, Config::isDebugLogEnabled), CodecUtils.option("activationAfter", Float.valueOf(30.0f), Codec.FLOAT, Config::getActivationAfter), CodecUtils.option("disableOnDamage", true, Codec.BOOL, Config::isDisableOnDamage), CodecUtils.option("disableOnDeath", true, Codec.BOOL, Config::isDisableOnDeath), CodecUtils.option("loadDefaultAnimation", true, Codec.BOOL, Config::isLoadDefaultAnimation), CodecUtils.option("cameraFollow", false, Codec.BOOL, Config::isCameraFollow)).apply((Applicative)instance, Config::new));
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("afkcam.json5").toFile();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AFK camera/Config");
    private static Config INSTANCE;
    private boolean modEnabled;
    private boolean debugLogEnabled;
    private float activationAfter;
    private boolean disableOnDamage;
    private boolean disableOnDeath;
    private boolean loadDefaultAnimation;
    private boolean cameraFollow;

    private Config() {
        throw new IllegalArgumentException();
    }

    public static Config getInstance() {
        return INSTANCE == null ? Config.reload() : INSTANCE;
    }

    public static Config reload() {
        INSTANCE = Config.read();
        return INSTANCE;
    }

    public static Config getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static Config read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    public boolean isModEnabled() {
        return this.modEnabled;
    }

    public boolean isDebugLogEnabled() {
        return this.debugLogEnabled;
    }

    public float getActivationAfter() {
        return this.activationAfter;
    }

    public boolean isDisableOnDamage() {
        return this.disableOnDamage;
    }

    public boolean isDisableOnDeath() {
        return this.disableOnDeath;
    }

    public boolean isLoadDefaultAnimation() {
        return this.loadDefaultAnimation;
    }

    public boolean isCameraFollow() {
        return this.cameraFollow;
    }

    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    public void setDebugLogEnabled(boolean debugLogEnabled) {
        this.debugLogEnabled = debugLogEnabled;
    }

    public void setActivationAfter(float activationAfter) {
        this.activationAfter = activationAfter;
    }

    public void setDisableOnDamage(boolean disableOnDamage) {
        this.disableOnDamage = disableOnDamage;
    }

    public void setDisableOnDeath(boolean disableOnDeath) {
        this.disableOnDeath = disableOnDeath;
    }

    public void setLoadDefaultAnimation(boolean loadDefaultAnimation) {
        this.loadDefaultAnimation = loadDefaultAnimation;
    }

    public void setCameraFollow(boolean cameraFollow) {
        this.cameraFollow = cameraFollow;
    }

    public Config(boolean modEnabled, boolean debugLogEnabled, float activationAfter, boolean disableOnDamage, boolean disableOnDeath, boolean loadDefaultAnimation, boolean cameraFollow) {
        this.modEnabled = modEnabled;
        this.debugLogEnabled = debugLogEnabled;
        this.activationAfter = activationAfter;
        this.disableOnDamage = disableOnDamage;
        this.disableOnDeath = disableOnDeath;
        this.loadDefaultAnimation = loadDefaultAnimation;
        this.cameraFollow = cameraFollow;
    }
}

